/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.format.parquet;

import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.format.FileFormat;
import org.apache.flink.table.store.format.FileStatsExtractor;
import org.apache.flink.table.store.format.parquet.ParquetFileStatsExtractor;
import org.apache.flink.table.store.format.parquet.ParquetInputFormatFactory;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.ParquetFileFormatFactory;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.row.ParquetRowDataBuilder;
import org.apache.flink.table.store.utils.Projection;
import org.apache.flink.table.types.logical.RowType;

public class ParquetFileFormat
extends FileFormat {
    private final Configuration formatOptions;

    public ParquetFileFormat(Configuration formatOptions) {
        super("parquet");
        this.formatOptions = formatOptions;
    }

    @VisibleForTesting
    Configuration formatOptions() {
        return this.formatOptions;
    }

    @Override
    public BulkFormat<RowData, FileSourceSplit> createReaderFactory(RowType type, int[][] projection, List<Predicate> filters) {
        return ParquetInputFormatFactory.create(ParquetFileFormat.getParquetConfiguration(this.formatOptions), (RowType)Projection.of(projection).project(type), InternalTypeInfo.of(type), this.formatOptions.get(ParquetFileFormatFactory.UTC_TIMEZONE));
    }

    @Override
    public BulkWriter.Factory<RowData> createWriterFactory(RowType type) {
        return ParquetRowDataBuilder.createWriterFactory(type, ParquetFileFormat.getParquetConfiguration(this.formatOptions), this.formatOptions.get(ParquetFileFormatFactory.UTC_TIMEZONE));
    }

    @Override
    public Optional<FileStatsExtractor> createStatsExtractor(RowType type) {
        return Optional.of(new ParquetFileStatsExtractor(type));
    }

    public static org.apache.hadoop.conf.Configuration getParquetConfiguration(Configuration options) {
        org.apache.hadoop.conf.Configuration conf = new org.apache.hadoop.conf.Configuration();
        options.toMap().forEach((key, value) -> conf.set("parquet." + key, value));
        return conf;
    }
}

