/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;

@Internal
public final class OffsetAwareOutputStream
implements Closeable {
    private final OutputStream currentOut;
    private long position;

    OffsetAwareOutputStream(OutputStream currentOut, long position) {
        this.currentOut = Preconditions.checkNotNull(currentOut);
        this.position = position;
    }

    public long getLength() {
        return this.position;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.currentOut.write(b, off, len);
        this.position += (long)len;
    }

    public void flush() throws IOException {
        this.currentOut.flush();
    }

    @Override
    public void close() {
        IOUtils.closeQuietly(this.currentOut);
    }
}

