/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.metrics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.job.metrics.AbstractAggregatingMetricsHandler;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.job.metrics.AggregateTaskManagerMetricsParameters;
import org.apache.flink.runtime.rest.messages.job.metrics.AggregatedTaskManagerMetricsHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.TaskManagersFilterQueryParameter;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class AggregatingTaskManagersMetricsHandler
extends AbstractAggregatingMetricsHandler<AggregateTaskManagerMetricsParameters> {
    public AggregatingTaskManagersMetricsHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, Executor executor, MetricFetcher fetcher) {
        super(leaderRetriever, timeout, responseHeaders, AggregatedTaskManagerMetricsHeaders.getInstance(), executor, fetcher);
    }

    @Override
    @Nonnull
    Collection<? extends MetricStore.ComponentMetricStore> getStores(MetricStore store, HandlerRequest<EmptyRequestBody> request) {
        List taskmanagers = request.getQueryParameter(TaskManagersFilterQueryParameter.class);
        if (taskmanagers.isEmpty()) {
            return store.getTaskManagers().values();
        }
        ArrayList<MetricStore.TaskManagerMetricStore> taskmanagerStores = new ArrayList<MetricStore.TaskManagerMetricStore>(taskmanagers.size());
        for (ResourceID taskmanager : taskmanagers) {
            MetricStore.TaskManagerMetricStore taskManagerMetricStore = store.getTaskManagerMetricStore(taskmanager.getResourceIdString());
            if (taskManagerMetricStore == null) continue;
            taskmanagerStores.add(taskManagerMetricStore);
        }
        return taskmanagerStores;
    }
}

