/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.CloseableRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncSnapshotCallable<T>
implements Callable<T> {
    private static final String CANCELLATION_EXCEPTION_MSG = "Async snapshot was cancelled.";
    private static final Logger LOG = LoggerFactory.getLogger(AsyncSnapshotCallable.class);
    @Nonnull
    private final AtomicBoolean resourceCleanupOwnershipTaken;
    @Nonnull
    protected final CloseableRegistry snapshotCloseableRegistry = new CloseableRegistry();

    protected AsyncSnapshotCallable() {
        this.resourceCleanupOwnershipTaken = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() throws Exception {
        long startTime = System.currentTimeMillis();
        if (this.resourceCleanupOwnershipTaken.compareAndSet(false, true)) {
            try {
                T result = this.callInternal();
                this.logAsyncSnapshotComplete(startTime);
                T t = result;
                return t;
            }
            catch (Exception ex) {
                if (!this.snapshotCloseableRegistry.isClosed()) {
                    throw ex;
                }
            }
            finally {
                this.closeSnapshotIO();
                this.cleanup();
            }
        }
        throw new CancellationException(CANCELLATION_EXCEPTION_MSG);
    }

    @VisibleForTesting
    protected void cancel() {
        this.closeSnapshotIO();
        if (this.resourceCleanupOwnershipTaken.compareAndSet(false, true)) {
            this.cleanup();
        }
    }

    public AsyncSnapshotTask toAsyncSnapshotFutureTask(@Nonnull CloseableRegistry taskRegistry) throws IOException {
        return new AsyncSnapshotTask(taskRegistry);
    }

    protected abstract T callInternal() throws Exception;

    protected abstract void cleanupProvidedResources();

    protected void logAsyncSnapshotComplete(long startTime) {
    }

    private void cleanup() {
        this.cleanupProvidedResources();
    }

    private void closeSnapshotIO() {
        try {
            this.snapshotCloseableRegistry.close();
        }
        catch (IOException e) {
            LOG.warn("Could not properly close incremental snapshot streams.", (Throwable)e);
        }
    }

    public class AsyncSnapshotTask
    extends FutureTask<T> {
        @Nonnull
        private final CloseableRegistry taskRegistry;
        @Nonnull
        private final Closeable cancelOnClose;

        private AsyncSnapshotTask(CloseableRegistry taskRegistry) throws IOException {
            super(AsyncSnapshotCallable.this);
            this.cancelOnClose = () -> this.cancel(true);
            this.taskRegistry = taskRegistry;
            taskRegistry.registerCloseable(this.cancelOnClose);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean result = super.cancel(mayInterruptIfRunning);
            if (mayInterruptIfRunning) {
                AsyncSnapshotCallable.this.cancel();
            }
            return result;
        }

        @Override
        protected void done() {
            super.done();
            this.taskRegistry.unregisterCloseable(this.cancelOnClose);
        }
    }
}

