/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.conversion;

import java.math.BigDecimal;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;

@Internal
public class DecimalBigDecimalConverter
implements DataStructureConverter<DecimalData, BigDecimal> {
    private static final long serialVersionUID = 1L;
    private final int precision;
    private final int scale;

    private DecimalBigDecimalConverter(int precision, int scale) {
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    public DecimalData toInternal(BigDecimal external) {
        return DecimalData.fromBigDecimal(external, this.precision, this.scale);
    }

    @Override
    public BigDecimal toExternal(DecimalData internal) {
        return internal.toBigDecimal();
    }

    static DecimalBigDecimalConverter create(DataType dataType) {
        DecimalType decimalType = (DecimalType)dataType.getLogicalType();
        return new DecimalBigDecimalConverter(decimalType.getPrecision(), decimalType.getScale());
    }
}

