/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.JsonExistsOnError;
import org.apache.flink.table.api.JsonOnNull;
import org.apache.flink.table.api.JsonQueryOnEmptyOrError;
import org.apache.flink.table.api.JsonQueryWrapper;
import org.apache.flink.table.api.JsonType;
import org.apache.flink.table.api.JsonValueOnEmptyOrError;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.TimePointUnit;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.inference.strategies.SpecificInputTypeStrategies;
import org.apache.flink.table.types.inference.strategies.SpecificTypeStrategies;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class BuiltInFunctionDefinitions {
    public static final BuiltInFunctionDefinition TYPE_OF = BuiltInFunctionDefinition.newBuilder().name("TYPEOF").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.sequence(new String[]{"input"}, new ArgumentTypeStrategy[]{InputTypeStrategies.ANY}), InputTypeStrategies.sequence(new String[]{"input", "force_serializable"}, new ArgumentTypeStrategy[]{InputTypeStrategies.ANY, InputTypeStrategies.and(InputTypeStrategies.logical(LogicalTypeRoot.BOOLEAN), InputTypeStrategies.LITERAL)}))).outputTypeStrategy(TypeStrategies.explicit(DataTypes.STRING())).runtimeClass("org.apache.flink.table.runtime.functions.scalar.TypeOfFunction").build();
    public static final BuiltInFunctionDefinition IF_NULL = BuiltInFunctionDefinition.newBuilder().name("IFNULL").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(Arrays.asList("input", "null_replacement"), Arrays.asList(InputTypeStrategies.COMMON_ARG_NULLABLE, InputTypeStrategies.COMMON_ARG_NULLABLE))).outputTypeStrategy(SpecificTypeStrategies.IF_NULL).runtimeClass("org.apache.flink.table.runtime.functions.scalar.IfNullFunction").build();
    public static final BuiltInFunctionDefinition SOURCE_WATERMARK = BuiltInFunctionDefinition.newBuilder().name("SOURCE_WATERMARK").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.NO_ARGS).outputTypeStrategy(SpecificTypeStrategies.SOURCE_WATERMARK).runtimeClass("org.apache.flink.table.runtime.functions.scalar.SourceWatermarkFunction").build();
    public static final BuiltInFunctionDefinition COALESCE = BuiltInFunctionDefinition.newBuilder().name("COALESCE").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.varyingSequence(InputTypeStrategies.COMMON_ARG_NULLABLE, InputTypeStrategies.COMMON_ARG_NULLABLE)).outputTypeStrategy(TypeStrategies.nullableIfAllArgs(TypeStrategies.COMMON)).runtimeClass("org.apache.flink.table.runtime.functions.scalar.CoalesceFunction").build();
    public static final BuiltInFunctionDefinition ARRAY_CONTAINS = BuiltInFunctionDefinition.newBuilder().name("ARRAY_CONTAINS").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(Arrays.asList("haystack", "needle"), Arrays.asList(InputTypeStrategies.logical(LogicalTypeRoot.ARRAY), SpecificInputTypeStrategies.ARRAY_ELEMENT_ARG))).outputTypeStrategy(TypeStrategies.nullableIfArgs(ConstantArgumentCount.of(0), TypeStrategies.explicit(DataTypes.BOOLEAN()))).runtimeClass("org.apache.flink.table.runtime.functions.scalar.ArrayContainsFunction").build();
    public static final BuiltInFunctionDefinition INTERNAL_REPLICATE_ROWS = BuiltInFunctionDefinition.newBuilder().name("$REPLICATE_ROWS$1").kind(FunctionKind.TABLE).outputTypeStrategy(SpecificTypeStrategies.INTERNAL_REPLICATE_ROWS).runtimeClass("org.apache.flink.table.runtime.functions.table.ReplicateRowsFunction").internal().build();
    public static final BuiltInFunctionDefinition INTERNAL_UNNEST_ROWS = BuiltInFunctionDefinition.newBuilder().name("$UNNEST_ROWS$1").kind(FunctionKind.TABLE).outputTypeStrategy(TypeStrategies.MISSING).runtimeClass("org.apache.flink.table.runtime.functions.table.UnnestRowsFunction").internal().build();
    public static final BuiltInFunctionDefinition AND = BuiltInFunctionDefinition.newBuilder().name("and").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.varyingSequence(InputTypeStrategies.logical(LogicalTypeRoot.BOOLEAN), InputTypeStrategies.logical(LogicalTypeRoot.BOOLEAN), InputTypeStrategies.logical(LogicalTypeRoot.BOOLEAN))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.BOOLEAN()))).build();
    public static final BuiltInFunctionDefinition OR = BuiltInFunctionDefinition.newBuilder().name("or").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.varyingSequence(InputTypeStrategies.logical(LogicalTypeRoot.BOOLEAN), InputTypeStrategies.logical(LogicalTypeRoot.BOOLEAN), InputTypeStrategies.logical(LogicalTypeRoot.BOOLEAN))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.BOOLEAN()))).build();
    public static final BuiltInFunctionDefinition NOT = BuiltInFunctionDefinition.newBuilder().name("not").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeRoot.BOOLEAN))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.BOOLEAN()))).build();
    public static final BuiltInFunctionDefinition IF = BuiltInFunctionDefinition.newBuilder().name("ifThenElse").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.compositeSequence().argument(InputTypeStrategies.logical(LogicalTypeRoot.BOOLEAN)).subsequence(InputTypeStrategies.commonType(2)).finish()).outputTypeStrategy(TypeStrategies.argument(1)).build();
    public static final BuiltInFunctionDefinition EQUALS = BuiltInFunctionDefinition.newBuilder().name("equals").kind(FunctionKind.SCALAR).inputTypeStrategy(SpecificInputTypeStrategies.TWO_EQUALS_COMPARABLE).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.BOOLEAN()))).build();
    public static final BuiltInFunctionDefinition GREATER_THAN = BuiltInFunctionDefinition.newBuilder().name("greaterThan").kind(FunctionKind.SCALAR).inputTypeStrategy(SpecificInputTypeStrategies.TWO_FULLY_COMPARABLE).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.BOOLEAN()))).build();
    public static final BuiltInFunctionDefinition GREATER_THAN_OR_EQUAL = BuiltInFunctionDefinition.newBuilder().name("greaterThanOrEqual").kind(FunctionKind.SCALAR).inputTypeStrategy(SpecificInputTypeStrategies.TWO_FULLY_COMPARABLE).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.BOOLEAN()))).build();
    public static final BuiltInFunctionDefinition LESS_THAN = BuiltInFunctionDefinition.newBuilder().name("lessThan").kind(FunctionKind.SCALAR).inputTypeStrategy(SpecificInputTypeStrategies.TWO_FULLY_COMPARABLE).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.BOOLEAN()))).build();
    public static final BuiltInFunctionDefinition LESS_THAN_OR_EQUAL = BuiltInFunctionDefinition.newBuilder().name("lessThanOrEqual").kind(FunctionKind.SCALAR).inputTypeStrategy(SpecificInputTypeStrategies.TWO_FULLY_COMPARABLE).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.BOOLEAN()))).build();
    public static final BuiltInFunctionDefinition NOT_EQUALS = BuiltInFunctionDefinition.newBuilder().name("notEquals").kind(FunctionKind.SCALAR).inputTypeStrategy(SpecificInputTypeStrategies.TWO_EQUALS_COMPARABLE).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.BOOLEAN()))).build();
    public static final BuiltInFunctionDefinition IS_NULL = BuiltInFunctionDefinition.newBuilder().name("isNull").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.wildcardWithCount(ConstantArgumentCount.of(1))).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.BOOLEAN().notNull())).build();
    public static final BuiltInFunctionDefinition IS_NOT_NULL = BuiltInFunctionDefinition.newBuilder().name("isNotNull").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.wildcardWithCount(ConstantArgumentCount.of(1))).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.BOOLEAN().notNull())).build();
    public static final BuiltInFunctionDefinition IS_TRUE = BuiltInFunctionDefinition.newBuilder().name("isTrue").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeRoot.BOOLEAN))).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.BOOLEAN().notNull())).build();
    public static final BuiltInFunctionDefinition IS_FALSE = BuiltInFunctionDefinition.newBuilder().name("isFalse").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeRoot.BOOLEAN))).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.BOOLEAN().notNull())).build();
    public static final BuiltInFunctionDefinition IS_NOT_TRUE = BuiltInFunctionDefinition.newBuilder().name("isNotTrue").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeRoot.BOOLEAN))).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.BOOLEAN().notNull())).build();
    public static final BuiltInFunctionDefinition IS_NOT_FALSE = BuiltInFunctionDefinition.newBuilder().name("isNotFalse").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeRoot.BOOLEAN))).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.BOOLEAN().notNull())).build();
    public static final BuiltInFunctionDefinition BETWEEN = BuiltInFunctionDefinition.newBuilder().name("between").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.comparable(ConstantArgumentCount.of(3), StructuredType.StructuredComparison.FULL)).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.BOOLEAN()))).build();
    public static final BuiltInFunctionDefinition NOT_BETWEEN = BuiltInFunctionDefinition.newBuilder().name("notBetween").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.comparable(ConstantArgumentCount.of(3), StructuredType.StructuredComparison.FULL)).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.BOOLEAN()))).build();
    public static final BuiltInFunctionDefinition GREATEST = BuiltInFunctionDefinition.newBuilder().name("GREATEST").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.comparable(ConstantArgumentCount.from(1), StructuredType.StructuredComparison.FULL)).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.COMMON)).runtimeProvided().build();
    public static final BuiltInFunctionDefinition LEAST = BuiltInFunctionDefinition.newBuilder().name("LEAST").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.comparable(ConstantArgumentCount.from(1), StructuredType.StructuredComparison.FULL)).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.COMMON)).runtimeProvided().build();
    public static final BuiltInFunctionDefinition AVG = BuiltInFunctionDefinition.newBuilder().name("avg").kind(FunctionKind.AGGREGATE).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC))).outputTypeStrategy(TypeStrategies.aggArg0(LogicalTypeMerging::findAvgAggType, true)).build();
    public static final BuiltInFunctionDefinition COUNT = BuiltInFunctionDefinition.newBuilder().name("count").kind(FunctionKind.AGGREGATE).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.ANY)).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.BIGINT().notNull())).build();
    public static final BuiltInFunctionDefinition MAX = BuiltInFunctionDefinition.newBuilder().name("max").kind(FunctionKind.AGGREGATE).inputTypeStrategy(InputTypeStrategies.comparable(ConstantArgumentCount.of(1), StructuredType.StructuredComparison.FULL)).outputTypeStrategy(TypeStrategies.aggArg0(t -> t, true)).build();
    public static final BuiltInFunctionDefinition MIN = BuiltInFunctionDefinition.newBuilder().name("min").kind(FunctionKind.AGGREGATE).inputTypeStrategy(InputTypeStrategies.comparable(ConstantArgumentCount.of(1), StructuredType.StructuredComparison.FULL)).outputTypeStrategy(TypeStrategies.aggArg0(t -> t, true)).build();
    public static final BuiltInFunctionDefinition FIRST_VALUE = BuiltInFunctionDefinition.newBuilder().name("first_value").kind(FunctionKind.AGGREGATE).outputTypeStrategy(TypeStrategies.aggArg0(t -> t, true)).build();
    public static final BuiltInFunctionDefinition LAST_VALUE = BuiltInFunctionDefinition.newBuilder().name("last_value").kind(FunctionKind.AGGREGATE).outputTypeStrategy(TypeStrategies.aggArg0(t -> t, true)).build();
    public static final BuiltInFunctionDefinition SUM = BuiltInFunctionDefinition.newBuilder().name("sum").kind(FunctionKind.AGGREGATE).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC))).outputTypeStrategy(TypeStrategies.aggArg0(LogicalTypeMerging::findSumAggType, true)).build();
    public static final BuiltInFunctionDefinition SUM0 = BuiltInFunctionDefinition.newBuilder().name("sum0").kind(FunctionKind.AGGREGATE).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC))).outputTypeStrategy(TypeStrategies.aggArg0(LogicalTypeMerging::findSumAggType, false)).build();
    public static final BuiltInFunctionDefinition STDDEV_POP = BuiltInFunctionDefinition.newBuilder().name("stddevPop").kind(FunctionKind.AGGREGATE).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC))).outputTypeStrategy(TypeStrategies.aggArg0(LogicalTypeMerging::findAvgAggType, true)).build();
    public static final BuiltInFunctionDefinition STDDEV_SAMP = BuiltInFunctionDefinition.newBuilder().name("stddevSamp").kind(FunctionKind.AGGREGATE).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC))).outputTypeStrategy(TypeStrategies.aggArg0(LogicalTypeMerging::findAvgAggType, true)).build();
    public static final BuiltInFunctionDefinition VAR_POP = BuiltInFunctionDefinition.newBuilder().name("varPop").kind(FunctionKind.AGGREGATE).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC))).outputTypeStrategy(TypeStrategies.aggArg0(LogicalTypeMerging::findAvgAggType, true)).build();
    public static final BuiltInFunctionDefinition VAR_SAMP = BuiltInFunctionDefinition.newBuilder().name("varSamp").kind(FunctionKind.AGGREGATE).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC))).outputTypeStrategy(TypeStrategies.aggArg0(LogicalTypeMerging::findAvgAggType, true)).build();
    public static final BuiltInFunctionDefinition COLLECT = BuiltInFunctionDefinition.newBuilder().name("collect").kind(FunctionKind.AGGREGATE).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition DISTINCT = BuiltInFunctionDefinition.newBuilder().name("distinct").kind(FunctionKind.AGGREGATE).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition CHAR_LENGTH = BuiltInFunctionDefinition.newBuilder().name("charLength").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.INT()))).build();
    public static final BuiltInFunctionDefinition INIT_CAP = BuiltInFunctionDefinition.newBuilder().name("initCap").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.argument(0))).build();
    public static final BuiltInFunctionDefinition LIKE = BuiltInFunctionDefinition.newBuilder().name("like").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.BOOLEAN()))).build();
    public static final BuiltInFunctionDefinition LOWER = BuiltInFunctionDefinition.newBuilder().name("lower").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.argument(0))).build();
    public static final BuiltInFunctionDefinition LOWERCASE = BuiltInFunctionDefinition.newBuilder().name("lowerCase").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.argument(0))).build();
    public static final BuiltInFunctionDefinition SIMILAR = BuiltInFunctionDefinition.newBuilder().name("similar").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.BOOLEAN()))).build();
    public static final BuiltInFunctionDefinition SUBSTRING = BuiltInFunctionDefinition.newBuilder().name("substring").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeRoot.INTEGER)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeRoot.INTEGER), InputTypeStrategies.logical(LogicalTypeRoot.INTEGER)))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.varyingString(TypeStrategies.argument(0)))).build();
    public static final BuiltInFunctionDefinition SUBSTR = BuiltInFunctionDefinition.newBuilder().name("substr").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeRoot.INTEGER)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeRoot.INTEGER), InputTypeStrategies.logical(LogicalTypeRoot.INTEGER)))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.varyingString(TypeStrategies.argument(0)))).build();
    public static final BuiltInFunctionDefinition REPLACE = BuiltInFunctionDefinition.newBuilder().name("replace").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.STRING()))).build();
    public static final BuiltInFunctionDefinition TRIM = BuiltInFunctionDefinition.newBuilder().name("trim").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeRoot.BOOLEAN), InputTypeStrategies.logical(LogicalTypeRoot.BOOLEAN), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.varyingString(TypeStrategies.argument(3)))).build();
    public static final BuiltInFunctionDefinition UPPER = BuiltInFunctionDefinition.newBuilder().name("upper").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.argument(0))).build();
    public static final BuiltInFunctionDefinition UPPERCASE = BuiltInFunctionDefinition.newBuilder().name("upperCase").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.argument(0))).build();
    public static final BuiltInFunctionDefinition POSITION = BuiltInFunctionDefinition.newBuilder().name("position").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.INT()))).build();
    public static final BuiltInFunctionDefinition OVERLAY = BuiltInFunctionDefinition.newBuilder().name("overlay").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeRoot.INTEGER)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeRoot.INTEGER), InputTypeStrategies.logical(LogicalTypeRoot.INTEGER)))).outputTypeStrategy(TypeStrategies.nullableIfArgs(SpecificTypeStrategies.STRING_CONCAT)).build();
    public static final BuiltInFunctionDefinition CONCAT = BuiltInFunctionDefinition.newBuilder().name("concat").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.varyingSequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING)), InputTypeStrategies.varyingSequence(InputTypeStrategies.logical(LogicalTypeFamily.BINARY_STRING), InputTypeStrategies.logical(LogicalTypeFamily.BINARY_STRING)))).outputTypeStrategy(TypeStrategies.nullableIfArgs(SpecificTypeStrategies.STRING_CONCAT)).build();
    public static final BuiltInFunctionDefinition CONCAT_WS = BuiltInFunctionDefinition.newBuilder().name("concat_ws").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.varyingSequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.STRING()))).build();
    public static final BuiltInFunctionDefinition LPAD = BuiltInFunctionDefinition.newBuilder().name("lpad").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeRoot.INTEGER), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.STRING()))).build();
    public static final BuiltInFunctionDefinition RPAD = BuiltInFunctionDefinition.newBuilder().name("rpad").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeRoot.INTEGER), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.STRING()))).build();
    public static final BuiltInFunctionDefinition REGEXP_EXTRACT = BuiltInFunctionDefinition.newBuilder().name("regexpExtract").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeRoot.INTEGER)))).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.STRING().nullable())).build();
    public static final BuiltInFunctionDefinition FROM_BASE64 = BuiltInFunctionDefinition.newBuilder().name("fromBase64").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.STRING()))).build();
    public static final BuiltInFunctionDefinition TO_BASE64 = BuiltInFunctionDefinition.newBuilder().name("toBase64").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.STRING()))).build();
    public static final BuiltInFunctionDefinition ASCII = BuiltInFunctionDefinition.newBuilder().name("ascii").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.TINYINT()))).build();
    public static final BuiltInFunctionDefinition CHR = BuiltInFunctionDefinition.newBuilder().name("chr").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.INTEGER_NUMERIC))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.CHAR(1)))).build();
    public static final BuiltInFunctionDefinition DECODE = BuiltInFunctionDefinition.newBuilder().name("decode").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.BINARY_STRING), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.STRING()))).build();
    public static final BuiltInFunctionDefinition ENCODE = BuiltInFunctionDefinition.newBuilder().name("encode").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.BYTES()))).build();
    public static final BuiltInFunctionDefinition LEFT = BuiltInFunctionDefinition.newBuilder().name("left").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.INTEGER_NUMERIC))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.varyingString(TypeStrategies.argument(0)))).build();
    public static final BuiltInFunctionDefinition RIGHT = BuiltInFunctionDefinition.newBuilder().name("right").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.INTEGER_NUMERIC))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.varyingString(TypeStrategies.argument(0)))).build();
    public static final BuiltInFunctionDefinition INSTR = BuiltInFunctionDefinition.newBuilder().name("instr").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.INT()))).build();
    public static final BuiltInFunctionDefinition LOCATE = BuiltInFunctionDefinition.newBuilder().name("locate").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.INTEGER_NUMERIC)))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.INT()))).build();
    public static final BuiltInFunctionDefinition PARSE_URL = BuiltInFunctionDefinition.newBuilder().name("parseUrl").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING)))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.STRING()))).build();
    public static final BuiltInFunctionDefinition UUID = BuiltInFunctionDefinition.newBuilder().name("uuid").kind(FunctionKind.SCALAR).notDeterministic().inputTypeStrategy(InputTypeStrategies.NO_ARGS).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.CHAR(36).notNull())).build();
    public static final BuiltInFunctionDefinition LTRIM = BuiltInFunctionDefinition.newBuilder().name("ltrim").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING)))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.varyingString(TypeStrategies.argument(0)))).build();
    public static final BuiltInFunctionDefinition RTRIM = BuiltInFunctionDefinition.newBuilder().name("rtrim").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING)))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.varyingString(TypeStrategies.argument(0)))).build();
    public static final BuiltInFunctionDefinition REPEAT = BuiltInFunctionDefinition.newBuilder().name("repeat").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeRoot.INTEGER))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.STRING()))).build();
    public static final BuiltInFunctionDefinition REGEXP = BuiltInFunctionDefinition.newBuilder().name("regexp").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.BOOLEAN()))).build();
    public static final BuiltInFunctionDefinition REGEXP_REPLACE = BuiltInFunctionDefinition.newBuilder().name("regexpReplace").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.STRING()))).build();
    public static final BuiltInFunctionDefinition REVERSE = BuiltInFunctionDefinition.newBuilder().name("reverse").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.STRING()))).build();
    public static final BuiltInFunctionDefinition SPLIT_INDEX = BuiltInFunctionDefinition.newBuilder().name("splitIndex").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeRoot.INTEGER))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.STRING()))).build();
    public static final BuiltInFunctionDefinition STR_TO_MAP = BuiltInFunctionDefinition.newBuilder().name("strToMap").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING)))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.MAP(DataTypes.STRING(), DataTypes.STRING())))).build();
    public static final BuiltInFunctionDefinition PLUS = BuiltInFunctionDefinition.newBuilder().name("plus").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC), InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeRoot.INTERVAL_DAY_TIME), InputTypeStrategies.logical(LogicalTypeRoot.INTERVAL_DAY_TIME)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeRoot.INTERVAL_YEAR_MONTH), InputTypeStrategies.logical(LogicalTypeRoot.INTERVAL_YEAR_MONTH)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.DATETIME), InputTypeStrategies.logical(LogicalTypeFamily.INTERVAL)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.INTERVAL), InputTypeStrategies.logical(LogicalTypeFamily.DATETIME)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.PREDEFINED)))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.first(SpecificTypeStrategies.DECIMAL_PLUS, TypeStrategies.COMMON, TypeStrategies.explicit(DataTypes.STRING())))).build();
    public static final BuiltInFunctionDefinition AGG_DECIMAL_PLUS = BuiltInFunctionDefinition.newBuilder().name("AGG_DECIMAL_PLUS").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeRoot.DECIMAL), InputTypeStrategies.logical(LogicalTypeRoot.DECIMAL))).outputTypeStrategy(SpecificTypeStrategies.AGG_DECIMAL_PLUS).runtimeProvided().build();
    public static final BuiltInFunctionDefinition MINUS = BuiltInFunctionDefinition.newBuilder().name("minus").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC), InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeRoot.INTERVAL_DAY_TIME), InputTypeStrategies.logical(LogicalTypeRoot.INTERVAL_DAY_TIME)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeRoot.INTERVAL_YEAR_MONTH), InputTypeStrategies.logical(LogicalTypeRoot.INTERVAL_YEAR_MONTH)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.DATETIME), InputTypeStrategies.logical(LogicalTypeFamily.INTERVAL)))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.first(SpecificTypeStrategies.DECIMAL_PLUS, TypeStrategies.COMMON))).build();
    public static final BuiltInFunctionDefinition AGG_DECIMAL_MINUS = BuiltInFunctionDefinition.newBuilder().name("AGG_DECIMAL_MINUS").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeRoot.DECIMAL), InputTypeStrategies.logical(LogicalTypeRoot.DECIMAL))).outputTypeStrategy(SpecificTypeStrategies.AGG_DECIMAL_PLUS).runtimeProvided().build();
    public static final BuiltInFunctionDefinition DIVIDE = BuiltInFunctionDefinition.newBuilder().name("divide").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC), InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.INTERVAL), InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC)))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.first(SpecificTypeStrategies.DECIMAL_DIVIDE, TypeStrategies.matchFamily(0, LogicalTypeFamily.INTERVAL), TypeStrategies.COMMON))).build();
    public static final BuiltInFunctionDefinition TIMES = BuiltInFunctionDefinition.newBuilder().name("times").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC), InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.INTERVAL), InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC), InputTypeStrategies.logical(LogicalTypeFamily.INTERVAL)))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.first(SpecificTypeStrategies.DECIMAL_TIMES, TypeStrategies.matchFamily(0, LogicalTypeFamily.INTERVAL), TypeStrategies.COMMON))).build();
    public static final BuiltInFunctionDefinition ABS = BuiltInFunctionDefinition.newBuilder().name("abs").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.INTERVAL)))).outputTypeStrategy(TypeStrategies.argument(0)).build();
    public static final BuiltInFunctionDefinition EXP = BuiltInFunctionDefinition.newBuilder().name("exp").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.DOUBLE()))).build();
    public static final BuiltInFunctionDefinition FLOOR = BuiltInFunctionDefinition.newBuilder().name("floor").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.INTERVAL)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.DATETIME), InputTypeStrategies.logical(LogicalTypeRoot.SYMBOL)))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.first(SpecificTypeStrategies.DECIMAL_SCALE_0, TypeStrategies.argument(0)))).build();
    public static final BuiltInFunctionDefinition CEIL = BuiltInFunctionDefinition.newBuilder().name("ceil").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.INTERVAL)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.DATETIME), InputTypeStrategies.logical(LogicalTypeRoot.SYMBOL)))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.first(SpecificTypeStrategies.DECIMAL_SCALE_0, TypeStrategies.argument(0)))).build();
    public static final BuiltInFunctionDefinition LOG10 = BuiltInFunctionDefinition.newBuilder().name("log10").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.DOUBLE()))).build();
    public static final BuiltInFunctionDefinition LOG2 = BuiltInFunctionDefinition.newBuilder().name("log2").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.DOUBLE()))).build();
    public static final BuiltInFunctionDefinition LN = BuiltInFunctionDefinition.newBuilder().name("ln").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.DOUBLE()))).build();
    public static final BuiltInFunctionDefinition LOG = BuiltInFunctionDefinition.newBuilder().name("log").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC), InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC)))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.DOUBLE()))).build();
    public static final BuiltInFunctionDefinition POWER = BuiltInFunctionDefinition.newBuilder().name("power").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC), InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.DOUBLE()))).build();
    public static final BuiltInFunctionDefinition MOD = BuiltInFunctionDefinition.newBuilder().name("mod").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.EXACT_NUMERIC), InputTypeStrategies.logical(LogicalTypeFamily.EXACT_NUMERIC))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.first(SpecificTypeStrategies.DECIMAL_MOD, TypeStrategies.argument(1)))).build();
    public static final BuiltInFunctionDefinition SQRT = BuiltInFunctionDefinition.newBuilder().name("sqrt").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.DOUBLE()))).build();
    public static final BuiltInFunctionDefinition MINUS_PREFIX = BuiltInFunctionDefinition.newBuilder().name("minusPrefix").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.sequence(InputTypeStrategies.OUTPUT_IF_NULL), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.INTERVAL)))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.argument(0))).build();
    public static final BuiltInFunctionDefinition SIN = BuiltInFunctionDefinition.newBuilder().name("sin").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.DOUBLE()))).build();
    public static final BuiltInFunctionDefinition COS = BuiltInFunctionDefinition.newBuilder().name("cos").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.DOUBLE()))).build();
    public static final BuiltInFunctionDefinition SINH = BuiltInFunctionDefinition.newBuilder().name("sinh").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.DOUBLE()))).build();
    public static final BuiltInFunctionDefinition TAN = BuiltInFunctionDefinition.newBuilder().name("tan").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.DOUBLE()))).build();
    public static final BuiltInFunctionDefinition TANH = BuiltInFunctionDefinition.newBuilder().name("tanh").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.DOUBLE()))).build();
    public static final BuiltInFunctionDefinition COT = BuiltInFunctionDefinition.newBuilder().name("cot").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.DOUBLE()))).build();
    public static final BuiltInFunctionDefinition ASIN = BuiltInFunctionDefinition.newBuilder().name("asin").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.DOUBLE()))).build();
    public static final BuiltInFunctionDefinition ACOS = BuiltInFunctionDefinition.newBuilder().name("acos").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.DOUBLE()))).build();
    public static final BuiltInFunctionDefinition ATAN = BuiltInFunctionDefinition.newBuilder().name("atan").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.DOUBLE()))).build();
    public static final BuiltInFunctionDefinition ATAN2 = BuiltInFunctionDefinition.newBuilder().name("atan2").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC), InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.DOUBLE()))).build();
    public static final BuiltInFunctionDefinition COSH = BuiltInFunctionDefinition.newBuilder().name("cosh").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.DOUBLE()))).build();
    public static final BuiltInFunctionDefinition DEGREES = BuiltInFunctionDefinition.newBuilder().name("degrees").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.DOUBLE()))).build();
    public static final BuiltInFunctionDefinition RADIANS = BuiltInFunctionDefinition.newBuilder().name("radians").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.DOUBLE()))).build();
    public static final BuiltInFunctionDefinition SIGN = BuiltInFunctionDefinition.newBuilder().name("sign").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC))).outputTypeStrategy(TypeStrategies.argument(0)).build();
    public static final BuiltInFunctionDefinition ROUND = BuiltInFunctionDefinition.newBuilder().name("round").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC), InputTypeStrategies.logical(LogicalTypeRoot.INTEGER)))).outputTypeStrategy(TypeStrategies.nullableIfArgs(SpecificTypeStrategies.ROUND)).build();
    public static final BuiltInFunctionDefinition PI = BuiltInFunctionDefinition.newBuilder().name("pi").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.NO_ARGS).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.DOUBLE().notNull())).build();
    public static final BuiltInFunctionDefinition E = BuiltInFunctionDefinition.newBuilder().name("e").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.NO_ARGS).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.DOUBLE().notNull())).build();
    public static final BuiltInFunctionDefinition RAND = BuiltInFunctionDefinition.newBuilder().name("rand").kind(FunctionKind.SCALAR).notDeterministic().inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.NO_ARGS, InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeRoot.INTEGER)))).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.DOUBLE().notNull())).build();
    public static final BuiltInFunctionDefinition RAND_INTEGER = BuiltInFunctionDefinition.newBuilder().name("randInteger").kind(FunctionKind.SCALAR).notDeterministic().inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeRoot.INTEGER)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeRoot.INTEGER), InputTypeStrategies.logical(LogicalTypeRoot.INTEGER)))).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.INT().notNull())).build();
    public static final BuiltInFunctionDefinition BIN = BuiltInFunctionDefinition.newBuilder().name("bin").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.INTEGER_NUMERIC))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.STRING()))).build();
    public static final BuiltInFunctionDefinition HEX = BuiltInFunctionDefinition.newBuilder().name("hex").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.INTEGER_NUMERIC)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING)))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.STRING()))).build();
    public static final BuiltInFunctionDefinition TRUNCATE = BuiltInFunctionDefinition.newBuilder().name("truncate").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC), InputTypeStrategies.logical(LogicalTypeRoot.INTEGER)))).outputTypeStrategy(TypeStrategies.nullableIfArgs(SpecificTypeStrategies.ROUND)).build();
    public static final BuiltInFunctionDefinition CURRENT_DATABASE = BuiltInFunctionDefinition.newBuilder().name("currentDatabase").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.STRING().notNull())).build();
    public static final BuiltInFunctionDefinition EXTRACT = BuiltInFunctionDefinition.newBuilder().name("extract").kind(FunctionKind.SCALAR).inputTypeStrategy(SpecificInputTypeStrategies.EXTRACT).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.BIGINT()))).build();
    public static final BuiltInFunctionDefinition CURRENT_DATE = BuiltInFunctionDefinition.newBuilder().name("currentDate").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.DATE().notNull())).build();
    public static final BuiltInFunctionDefinition CURRENT_TIME = BuiltInFunctionDefinition.newBuilder().name("currentTime").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.TIME().notNull())).build();
    public static final BuiltInFunctionDefinition CURRENT_TIMESTAMP = BuiltInFunctionDefinition.newBuilder().name("currentTimestamp").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.TIMESTAMP_LTZ(3).notNull())).build();
    public static final BuiltInFunctionDefinition CURRENT_ROW_TIMESTAMP = BuiltInFunctionDefinition.newBuilder().name("currentRowTimestamp").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.TIMESTAMP_LTZ(3).notNull())).build();
    public static final BuiltInFunctionDefinition LOCAL_TIME = BuiltInFunctionDefinition.newBuilder().name("localTime").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.TIME().notNull())).build();
    public static final BuiltInFunctionDefinition LOCAL_TIMESTAMP = BuiltInFunctionDefinition.newBuilder().name("localTimestamp").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.TIMESTAMP(3).notNull())).build();
    public static final BuiltInFunctionDefinition TEMPORAL_OVERLAPS = BuiltInFunctionDefinition.newBuilder().name("temporalOverlaps").kind(FunctionKind.SCALAR).inputTypeStrategy(SpecificInputTypeStrategies.TEMPORAL_OVERLAPS).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.BOOLEAN()))).build();
    public static final BuiltInFunctionDefinition DATE_FORMAT = BuiltInFunctionDefinition.newBuilder().name("dateFormat").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.TIMESTAMP), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING)))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.STRING()))).build();
    public static final BuiltInFunctionDefinition TIMESTAMP_DIFF = BuiltInFunctionDefinition.newBuilder().name("timestampDiff").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.symbol((Enum)TimePointUnit.YEAR, (Enum[])new TimePointUnit[]{TimePointUnit.QUARTER, TimePointUnit.MONTH, TimePointUnit.WEEK, TimePointUnit.DAY, TimePointUnit.HOUR, TimePointUnit.MINUTE, TimePointUnit.SECOND}), InputTypeStrategies.logical(LogicalTypeFamily.DATETIME), InputTypeStrategies.logical(LogicalTypeFamily.DATETIME))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.INT()))).build();
    public static final BuiltInFunctionDefinition FROM_UNIXTIME = BuiltInFunctionDefinition.newBuilder().name("fromUnixtime").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING)))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.STRING()))).build();
    public static final BuiltInFunctionDefinition TO_TIMESTAMP_LTZ = BuiltInFunctionDefinition.newBuilder().name("toTimestampLtz").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC), InputTypeStrategies.logical(LogicalTypeFamily.INTEGER_NUMERIC, false))).outputTypeStrategy(SpecificTypeStrategies.TO_TIMESTAMP_LTZ).build();
    public static final BuiltInFunctionDefinition AT = BuiltInFunctionDefinition.newBuilder().name("at").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition CARDINALITY = BuiltInFunctionDefinition.newBuilder().name("cardinality").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition ARRAY = BuiltInFunctionDefinition.newBuilder().name("array").kind(FunctionKind.SCALAR).inputTypeStrategy(SpecificInputTypeStrategies.ARRAY).outputTypeStrategy(SpecificTypeStrategies.ARRAY).build();
    public static final BuiltInFunctionDefinition ARRAY_ELEMENT = BuiltInFunctionDefinition.newBuilder().name("element").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition MAP = BuiltInFunctionDefinition.newBuilder().name("map").kind(FunctionKind.SCALAR).inputTypeStrategy(SpecificInputTypeStrategies.MAP).outputTypeStrategy(SpecificTypeStrategies.MAP).build();
    public static final BuiltInFunctionDefinition ROW = BuiltInFunctionDefinition.newBuilder().name("row").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.wildcardWithCount(ConstantArgumentCount.from(1))).outputTypeStrategy(SpecificTypeStrategies.ROW).build();
    public static final BuiltInFunctionDefinition FLATTEN = BuiltInFunctionDefinition.newBuilder().name("flatten").kind(FunctionKind.OTHER).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.COMPOSITE)).outputTypeStrategy(callContext -> {
        throw new UnsupportedOperationException("FLATTEN should be resolved to GET expressions");
    }).build();
    public static final BuiltInFunctionDefinition GET = BuiltInFunctionDefinition.newBuilder().name("get").kind(FunctionKind.OTHER).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.COMPOSITE, InputTypeStrategies.and(InputTypeStrategies.LITERAL, InputTypeStrategies.or(InputTypeStrategies.logical(LogicalTypeRoot.INTEGER), InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))))).outputTypeStrategy(SpecificTypeStrategies.GET).build();
    public static final BuiltInFunctionDefinition MD5 = BuiltInFunctionDefinition.newBuilder().name("md5").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.CHAR(32)))).build();
    public static final BuiltInFunctionDefinition SHA1 = BuiltInFunctionDefinition.newBuilder().name("sha1").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.CHAR(40)))).build();
    public static final BuiltInFunctionDefinition SHA224 = BuiltInFunctionDefinition.newBuilder().name("sha224").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.CHAR(56)))).build();
    public static final BuiltInFunctionDefinition SHA256 = BuiltInFunctionDefinition.newBuilder().name("sha256").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.CHAR(64)))).build();
    public static final BuiltInFunctionDefinition SHA384 = BuiltInFunctionDefinition.newBuilder().name("sha384").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.CHAR(96)))).build();
    public static final BuiltInFunctionDefinition SHA512 = BuiltInFunctionDefinition.newBuilder().name("sha512").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.CHAR(128)))).build();
    public static final BuiltInFunctionDefinition SHA2 = BuiltInFunctionDefinition.newBuilder().name("sha2").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.logical(LogicalTypeRoot.INTEGER))).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.VARCHAR(128)))).build();
    public static final BuiltInFunctionDefinition WINDOW_START = BuiltInFunctionDefinition.newBuilder().name("start").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition WINDOW_END = BuiltInFunctionDefinition.newBuilder().name("end").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition ORDER_ASC = BuiltInFunctionDefinition.newBuilder().name("asc").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition ORDER_DESC = BuiltInFunctionDefinition.newBuilder().name("desc").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition PROCTIME = BuiltInFunctionDefinition.newBuilder().name("proctime").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition ROWTIME = BuiltInFunctionDefinition.newBuilder().name("rowtime").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition CURRENT_WATERMARK = BuiltInFunctionDefinition.newBuilder().name("CURRENT_WATERMARK").kind(FunctionKind.SCALAR).inputTypeStrategy(SpecificInputTypeStrategies.CURRENT_WATERMARK).outputTypeStrategy(SpecificTypeStrategies.CURRENT_WATERMARK).notDeterministic().runtimeProvided().build();
    public static final BuiltInFunctionDefinition OVER = BuiltInFunctionDefinition.newBuilder().name("over").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition UNBOUNDED_RANGE = BuiltInFunctionDefinition.newBuilder().name("unboundedRange").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition UNBOUNDED_ROW = BuiltInFunctionDefinition.newBuilder().name("unboundedRow").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition CURRENT_RANGE = BuiltInFunctionDefinition.newBuilder().name("currentRange").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition CURRENT_ROW = BuiltInFunctionDefinition.newBuilder().name("currentRow").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition WITH_COLUMNS = BuiltInFunctionDefinition.newBuilder().name("withColumns").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition WITHOUT_COLUMNS = BuiltInFunctionDefinition.newBuilder().name("withoutColumns").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition IS_JSON = BuiltInFunctionDefinition.newBuilder().name("IS_JSON").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.symbol(JsonType.class)))).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.BOOLEAN().notNull())).runtimeDeferred().build();
    public static final BuiltInFunctionDefinition JSON_EXISTS = BuiltInFunctionDefinition.newBuilder().name("JSON_EXISTS").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.or(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.and(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.LITERAL)), InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.and(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.LITERAL), InputTypeStrategies.symbol(JsonExistsOnError.class)))).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.BOOLEAN().nullable())).runtimeDeferred().build();
    public static final BuiltInFunctionDefinition JSON_VALUE = BuiltInFunctionDefinition.newBuilder().name("JSON_VALUE").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.and(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.LITERAL), InputTypeStrategies.TYPE_LITERAL, InputTypeStrategies.symbol(JsonValueOnEmptyOrError.class), InputTypeStrategies.ANY, InputTypeStrategies.symbol(JsonValueOnEmptyOrError.class), InputTypeStrategies.ANY)).outputTypeStrategy(TypeStrategies.forceNullable(TypeStrategies.argument(2))).runtimeDeferred().build();
    public static final BuiltInFunctionDefinition JSON_QUERY = BuiltInFunctionDefinition.newBuilder().name("JSON_QUERY").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.and(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), InputTypeStrategies.LITERAL), InputTypeStrategies.symbol(JsonQueryWrapper.class), InputTypeStrategies.symbol(JsonQueryOnEmptyOrError.class), InputTypeStrategies.symbol(JsonQueryOnEmptyOrError.class))).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.STRING().nullable())).runtimeDeferred().build();
    public static final BuiltInFunctionDefinition JSON_STRING = BuiltInFunctionDefinition.newBuilder().name("JSON_STRING").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.sequence(SpecificInputTypeStrategies.JSON_ARGUMENT)).outputTypeStrategy(TypeStrategies.nullableIfArgs(TypeStrategies.explicit(DataTypes.STRING()))).runtimeProvided().build();
    public static final BuiltInFunctionDefinition JSON_OBJECT = BuiltInFunctionDefinition.newBuilder().name("JSON_OBJECT").kind(FunctionKind.SCALAR).inputTypeStrategy(SpecificInputTypeStrategies.JSON_OBJECT).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.STRING().notNull())).runtimeDeferred().build();
    public static final BuiltInFunctionDefinition JSON_OBJECTAGG_NULL_ON_NULL = BuiltInFunctionDefinition.newBuilder().name("JSON_OBJECTAGG_NULL_ON_NULL").kind(FunctionKind.AGGREGATE).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), SpecificInputTypeStrategies.JSON_ARGUMENT)).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.STRING().notNull())).runtimeDeferred().build();
    public static final BuiltInFunctionDefinition JSON_OBJECTAGG_ABSENT_ON_NULL = BuiltInFunctionDefinition.newBuilder().name("JSON_OBJECTAGG_ABSENT_ON_NULL").kind(FunctionKind.AGGREGATE).inputTypeStrategy(InputTypeStrategies.sequence(InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING), SpecificInputTypeStrategies.JSON_ARGUMENT)).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.STRING().notNull())).runtimeDeferred().build();
    public static final BuiltInFunctionDefinition JSON_ARRAY = BuiltInFunctionDefinition.newBuilder().name("JSON_ARRAY").kind(FunctionKind.SCALAR).inputTypeStrategy(InputTypeStrategies.varyingSequence(InputTypeStrategies.symbol(JsonOnNull.class), SpecificInputTypeStrategies.JSON_ARGUMENT)).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.STRING().notNull())).runtimeDeferred().build();
    public static final BuiltInFunctionDefinition JSON_ARRAYAGG_NULL_ON_NULL = BuiltInFunctionDefinition.newBuilder().name("JSON_ARRAYAGG_NULL_ON_NULL").kind(FunctionKind.AGGREGATE).inputTypeStrategy(InputTypeStrategies.sequence(SpecificInputTypeStrategies.JSON_ARGUMENT)).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.STRING().notNull())).runtimeDeferred().build();
    public static final BuiltInFunctionDefinition JSON_ARRAYAGG_ABSENT_ON_NULL = BuiltInFunctionDefinition.newBuilder().name("JSON_ARRAYAGG_ABSENT_ON_NULL").kind(FunctionKind.AGGREGATE).inputTypeStrategy(InputTypeStrategies.sequence(SpecificInputTypeStrategies.JSON_ARGUMENT)).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.STRING().notNull())).runtimeDeferred().build();
    public static final BuiltInFunctionDefinition IN = BuiltInFunctionDefinition.newBuilder().name("in").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition CAST = BuiltInFunctionDefinition.newBuilder().name("cast").kind(FunctionKind.SCALAR).inputTypeStrategy(SpecificInputTypeStrategies.CAST).outputTypeStrategy(TypeStrategies.nullableIfArgs(ConstantArgumentCount.to(0), TypeStrategies.argument(1))).build();
    public static final BuiltInFunctionDefinition TRY_CAST = BuiltInFunctionDefinition.newBuilder().name("TRY_CAST").kind(FunctionKind.SCALAR).inputTypeStrategy(SpecificInputTypeStrategies.CAST).outputTypeStrategy(TypeStrategies.forceNullable(TypeStrategies.argument(1))).build();
    public static final BuiltInFunctionDefinition REINTERPRET_CAST = BuiltInFunctionDefinition.newBuilder().name("reinterpretCast").kind(FunctionKind.SCALAR).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition AS = BuiltInFunctionDefinition.newBuilder().name("as").kind(FunctionKind.OTHER).inputTypeStrategy(InputTypeStrategies.varyingSequence(InputTypeStrategies.or(InputTypeStrategies.OUTPUT_IF_NULL, InputTypeStrategies.ANY), InputTypeStrategies.and(InputTypeStrategies.LITERAL, InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING)), InputTypeStrategies.and(InputTypeStrategies.LITERAL, InputTypeStrategies.logical(LogicalTypeFamily.CHARACTER_STRING)))).outputTypeStrategy(TypeStrategies.argument(0)).build();
    public static final BuiltInFunctionDefinition STREAM_RECORD_TIMESTAMP = BuiltInFunctionDefinition.newBuilder().name("streamRecordTimestamp").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final BuiltInFunctionDefinition RANGE_TO = BuiltInFunctionDefinition.newBuilder().name("rangeTo").kind(FunctionKind.OTHER).outputTypeStrategy(TypeStrategies.MISSING).build();
    public static final Set<FunctionDefinition> WINDOW_PROPERTIES = new HashSet<BuiltInFunctionDefinition>(Arrays.asList(WINDOW_START, WINDOW_END, PROCTIME, ROWTIME));
    public static final Set<FunctionDefinition> TIME_ATTRIBUTES = new HashSet<BuiltInFunctionDefinition>(Arrays.asList(PROCTIME, ROWTIME));
    public static final List<FunctionDefinition> ORDERING = Arrays.asList(ORDER_ASC, ORDER_DESC);

    @Internal
    public static List<BuiltInFunctionDefinition> getDefinitions() {
        Field[] fields = BuiltInFunctionDefinitions.class.getFields();
        ArrayList<BuiltInFunctionDefinition> list = new ArrayList<BuiltInFunctionDefinition>(fields.length);
        for (Field field : fields) {
            if (!FunctionDefinition.class.isAssignableFrom(field.getType())) continue;
            try {
                BuiltInFunctionDefinition funcDef = (BuiltInFunctionDefinition)field.get(BuiltInFunctionDefinitions.class);
                list.add(Preconditions.checkNotNull(funcDef));
            }
            catch (IllegalAccessException e) {
                throw new TableException("The function definition for field " + field.getName() + " is not accessible.", e);
            }
        }
        return list;
    }
}

