/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.catalog;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.store.CatalogOptions;
import org.apache.flink.table.store.file.catalog.Catalog;
import org.apache.flink.util.Preconditions;

public interface CatalogFactory {
    public String identifier();

    public Catalog create(String var1, Configuration var2);

    public static Path warehouse(Configuration options) {
        String warehouse = Preconditions.checkNotNull(options.get(CatalogOptions.WAREHOUSE), "Table store '" + CatalogOptions.WAREHOUSE.key() + "' path must be set");
        return new Path(warehouse);
    }

    public static Catalog createCatalog(Configuration options) {
        return CatalogFactory.createCatalog(options, Thread.currentThread().getContextClassLoader());
    }

    public static Catalog createCatalog(Configuration options, ClassLoader classLoader) {
        String warehouse = CatalogFactory.warehouse(options).toUri().toString();
        String metastore = options.get(CatalogOptions.METASTORE);
        ArrayList factories = new ArrayList();
        ServiceLoader.load(CatalogFactory.class, classLoader).iterator().forEachRemaining(f -> {
            if (f.identifier().equals(metastore)) {
                factories.add(f);
            }
        });
        if (factories.size() != 1) {
            throw new RuntimeException("Found " + factories.size() + " classes implementing " + CatalogFactory.class.getName() + " with metastore " + metastore + ". They are:\n" + factories.stream().map(t -> t.getClass().getName()).collect(Collectors.joining("\n")));
        }
        try {
            Path warehousePath = new Path(warehouse);
            FileSystem fs = warehousePath.getFileSystem();
            if (fs.exists(warehousePath)) {
                Preconditions.checkArgument(fs.getFileStatus(warehousePath).isDir(), "The %s path '%s' should be a directory.", CatalogOptions.WAREHOUSE.key(), warehouse);
            } else {
                fs.mkdirs(warehousePath);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return ((CatalogFactory)factories.get(0)).create(warehouse, options);
    }
}

