/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.vector;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.columnar.vector.BytesColumnVector;
import org.apache.flink.table.data.columnar.vector.ColumnVector;
import org.apache.flink.table.data.columnar.vector.DecimalColumnVector;
import org.apache.flink.table.data.columnar.vector.IntColumnVector;
import org.apache.flink.table.data.columnar.vector.LongColumnVector;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.utils.ParquetSchemaConverter;
import org.apache.flink.table.store.shaded.org.apache.parquet.Preconditions;

@Internal
public class ParquetDecimalVector
implements DecimalColumnVector {
    private final ColumnVector vector;

    public ParquetDecimalVector(ColumnVector vector) {
        this.vector = vector;
    }

    @Override
    public DecimalData getDecimal(int i, int precision, int scale) {
        if (ParquetSchemaConverter.is32BitDecimal(precision) && this.vector instanceof IntColumnVector) {
            return DecimalData.fromUnscaledLong(((IntColumnVector)this.vector).getInt(i), precision, scale);
        }
        if (ParquetSchemaConverter.is64BitDecimal(precision) && this.vector instanceof LongColumnVector) {
            return DecimalData.fromUnscaledLong(((LongColumnVector)this.vector).getLong(i), precision, scale);
        }
        Preconditions.checkArgument(this.vector instanceof BytesColumnVector, "Reading decimal type occur unsupported vector type: %s", this.vector.getClass());
        return DecimalData.fromUnscaledBytes(((BytesColumnVector)this.vector).getBytes(i).getBytes(), precision, scale);
    }

    public ColumnVector getVector() {
        return this.vector;
    }

    @Override
    public boolean isNullAt(int i) {
        return this.vector.isNullAt(i);
    }
}

