/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher.runner;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.dispatcher.runner.DispatcherRunner;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.util.concurrent.FutureUtils;

final class DispatcherRunnerLeaderElectionLifecycleManager<T extends DispatcherRunner & LeaderContender>
implements DispatcherRunner {
    private final T dispatcherRunner;
    private final LeaderElectionService leaderElectionService;

    private DispatcherRunnerLeaderElectionLifecycleManager(T dispatcherRunner, LeaderElectionService leaderElectionService) throws Exception {
        this.dispatcherRunner = dispatcherRunner;
        this.leaderElectionService = leaderElectionService;
        leaderElectionService.start((LeaderContender)dispatcherRunner);
    }

    @Override
    public CompletableFuture<ApplicationStatus> getShutDownFuture() {
        return this.dispatcherRunner.getShutDownFuture();
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        CompletableFuture<Void> servicesTerminationFuture = this.stopServices();
        CompletableFuture<Void> dispatcherRunnerTerminationFuture = this.dispatcherRunner.closeAsync();
        return FutureUtils.completeAll(Arrays.asList(servicesTerminationFuture, dispatcherRunnerTerminationFuture));
    }

    private CompletableFuture<Void> stopServices() {
        try {
            this.leaderElectionService.stop();
        }
        catch (Exception e) {
            return FutureUtils.completedExceptionally(e);
        }
        return FutureUtils.completedVoidFuture();
    }

    public static <T extends DispatcherRunner & LeaderContender> DispatcherRunner createFor(T dispatcherRunner, LeaderElectionService leaderElectionService) throws Exception {
        return new DispatcherRunnerLeaderElectionLifecycleManager<T>(dispatcherRunner, leaderElectionService);
    }
}

