/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.spark;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.store.file.catalog.Catalog;
import org.apache.flink.table.store.file.catalog.CatalogFactory;
import org.apache.flink.table.store.file.operation.Lock;
import org.apache.flink.table.store.file.schema.SchemaChange;
import org.apache.flink.table.store.file.schema.UpdateSchema;
import org.apache.flink.table.store.filesystem.FileSystems;
import org.apache.flink.table.store.spark.SparkCaseSensitiveConverter;
import org.apache.flink.table.store.spark.SparkTable;
import org.apache.flink.table.store.spark.SparkTypeUtils;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import org.apache.spark.sql.catalyst.analysis.NamespaceAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class SparkCatalog
implements TableCatalog,
SupportsNamespaces {
    private static final String PRIMARY_KEY_IDENTIFIER = "primary-key";
    private String name = null;
    private Catalog catalog = null;
    private Configuration conf = null;

    public void initialize(String name, CaseInsensitiveStringMap options) {
        this.name = name;
        this.conf = Configuration.fromMap(SparkCaseSensitiveConverter.convert((Map<String, String>)options));
        FileSystems.initialize(CatalogFactory.warehouse(this.conf), this.conf);
        this.catalog = CatalogFactory.createCatalog(this.conf);
    }

    public String name() {
        return this.name;
    }

    public String[] defaultNamespace() {
        return new String[]{"default"};
    }

    public void createNamespace(String[] namespace, Map<String, String> metadata) throws NamespaceAlreadyExistsException {
        Preconditions.checkArgument(this.isValidateNamespace(namespace), "Namespace %s is not valid", Arrays.toString(namespace));
        try {
            this.catalog.createDatabase(namespace[0], false);
        }
        catch (Catalog.DatabaseAlreadyExistException e) {
            throw new NamespaceAlreadyExistsException(namespace);
        }
    }

    public String[][] listNamespaces() {
        List<String> databases = this.catalog.listDatabases();
        String[][] namespaces = new String[databases.size()][];
        for (int i = 0; i < databases.size(); ++i) {
            namespaces[i] = new String[]{databases.get(i)};
        }
        return namespaces;
    }

    public String[][] listNamespaces(String[] namespace) throws NoSuchNamespaceException {
        if (namespace.length == 0) {
            return this.listNamespaces();
        }
        if (!this.isValidateNamespace(namespace)) {
            throw new NoSuchNamespaceException(namespace);
        }
        if (this.catalog.databaseExists(namespace[0])) {
            return new String[0][];
        }
        throw new NoSuchNamespaceException(namespace);
    }

    public Map<String, String> loadNamespaceMetadata(String[] namespace) throws NoSuchNamespaceException {
        Preconditions.checkArgument(this.isValidateNamespace(namespace), "Namespace %s is not valid", Arrays.toString(namespace));
        if (this.catalog.databaseExists(namespace[0])) {
            return Collections.emptyMap();
        }
        throw new NoSuchNamespaceException(namespace);
    }

    public boolean dropNamespace(String[] namespace) throws NoSuchNamespaceException {
        return this.dropNamespace(namespace, false);
    }

    public boolean dropNamespace(String[] namespace, boolean cascade) throws NoSuchNamespaceException {
        Preconditions.checkArgument(this.isValidateNamespace(namespace), "Namespace %s is not valid", Arrays.toString(namespace));
        try {
            this.catalog.dropDatabase(namespace[0], false, cascade);
            return true;
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new NoSuchNamespaceException(namespace);
        }
        catch (Catalog.DatabaseNotEmptyException e) {
            throw new UnsupportedOperationException(String.format("Namespace %s is not empty", Arrays.toString(namespace)));
        }
    }

    public Identifier[] listTables(String[] namespace) throws NoSuchNamespaceException {
        Preconditions.checkArgument(this.isValidateNamespace(namespace), "Missing database in namespace: %s", Arrays.toString(namespace));
        try {
            return (Identifier[])this.catalog.listTables(namespace[0]).stream().map(table -> Identifier.of((String[])namespace, (String)table)).toArray(Identifier[]::new);
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new NoSuchNamespaceException(namespace);
        }
    }

    public SparkTable loadTable(Identifier ident) throws NoSuchTableException {
        try {
            ObjectPath path = this.objectPath(ident);
            return new SparkTable(this.catalog.getTable(path), Lock.factory(this.catalog.lockFactory().orElse(null), path), this.conf);
        }
        catch (Catalog.TableNotExistException e) {
            throw new NoSuchTableException(ident);
        }
    }

    public Table alterTable(Identifier ident, TableChange ... changes) throws NoSuchTableException {
        List<SchemaChange> schemaChanges = Arrays.stream(changes).map(this::toSchemaChange).collect(Collectors.toList());
        try {
            this.catalog.alterTable(this.objectPath(ident), schemaChanges, false);
            return this.loadTable(ident);
        }
        catch (Catalog.TableNotExistException e) {
            throw new NoSuchTableException(ident);
        }
    }

    public Table createTable(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties) throws TableAlreadyExistsException, NoSuchNamespaceException {
        try {
            this.catalog.createTable(this.objectPath(ident), this.toUpdateSchema(schema, partitions, properties), false);
            return this.loadTable(ident);
        }
        catch (Catalog.TableAlreadyExistException e) {
            throw new TableAlreadyExistsException(ident);
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new NoSuchNamespaceException(ident.namespace());
        }
        catch (NoSuchTableException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean dropTable(Identifier ident) {
        try {
            this.catalog.dropTable(this.objectPath(ident), false);
            return true;
        }
        catch (Catalog.TableNotExistException | NoSuchTableException e) {
            return false;
        }
    }

    private SchemaChange toSchemaChange(TableChange change) {
        if (change instanceof TableChange.SetProperty) {
            TableChange.SetProperty set = (TableChange.SetProperty)change;
            this.validateAlterProperty(set.property());
            return SchemaChange.setOption(set.property(), set.value());
        }
        if (change instanceof TableChange.RemoveProperty) {
            TableChange.RemoveProperty remove = (TableChange.RemoveProperty)change;
            this.validateAlterProperty(remove.property());
            return SchemaChange.removeOption(remove.property());
        }
        if (change instanceof TableChange.AddColumn) {
            TableChange.AddColumn add = (TableChange.AddColumn)change;
            this.validateAlterNestedField(add.fieldNames());
            return SchemaChange.addColumn(add.fieldNames()[0], SparkTypeUtils.toFlinkType(add.dataType()).copy(add.isNullable()), add.comment());
        }
        if (change instanceof TableChange.RenameColumn) {
            TableChange.RenameColumn rename = (TableChange.RenameColumn)change;
            this.validateAlterNestedField(rename.fieldNames());
            return SchemaChange.renameColumn(rename.fieldNames()[0], rename.newName());
        }
        if (change instanceof TableChange.DeleteColumn) {
            TableChange.DeleteColumn delete = (TableChange.DeleteColumn)change;
            this.validateAlterNestedField(delete.fieldNames());
            return SchemaChange.dropColumn(delete.fieldNames()[0]);
        }
        if (change instanceof TableChange.UpdateColumnType) {
            TableChange.UpdateColumnType update = (TableChange.UpdateColumnType)change;
            this.validateAlterNestedField(update.fieldNames());
            return SchemaChange.updateColumnType(update.fieldNames()[0], SparkTypeUtils.toFlinkType(update.newDataType()));
        }
        if (change instanceof TableChange.UpdateColumnNullability) {
            TableChange.UpdateColumnNullability update = (TableChange.UpdateColumnNullability)change;
            return SchemaChange.updateColumnNullability(update.fieldNames(), update.nullable());
        }
        if (change instanceof TableChange.UpdateColumnComment) {
            TableChange.UpdateColumnComment update = (TableChange.UpdateColumnComment)change;
            return SchemaChange.updateColumnComment(update.fieldNames(), update.newComment());
        }
        throw new UnsupportedOperationException("Change is not supported: " + change.getClass());
    }

    private UpdateSchema toUpdateSchema(StructType schema, Transform[] partitions, Map<String, String> properties) {
        Preconditions.checkArgument(Arrays.stream(partitions).allMatch(partition -> {
            NamedReference[] references = partition.references();
            return references.length == 1 && references[0] instanceof FieldReference;
        }));
        HashMap<String, String> normalizedProperties = new HashMap<String, String>(properties);
        normalizedProperties.remove(PRIMARY_KEY_IDENTIFIER);
        String pkAsString = properties.get(PRIMARY_KEY_IDENTIFIER);
        List<String> primaryKeys = pkAsString == null ? Collections.emptyList() : Arrays.stream(pkAsString.split(",")).map(String::trim).collect(Collectors.toList());
        return new UpdateSchema((RowType)SparkTypeUtils.toFlinkType((DataType)schema), Arrays.stream(partitions).map(partition -> partition.references()[0].describe()).collect(Collectors.toList()), primaryKeys, normalizedProperties, properties.getOrDefault("comment", ""));
    }

    private void validateAlterNestedField(String[] fieldNames) {
        if (fieldNames.length > 1) {
            throw new UnsupportedOperationException("Alter nested column is not supported: " + Arrays.toString(fieldNames));
        }
    }

    private void validateAlterProperty(String alterKey) {
        if (PRIMARY_KEY_IDENTIFIER.equals(alterKey)) {
            throw new UnsupportedOperationException("Alter primary key is not supported");
        }
    }

    private boolean isValidateNamespace(String[] namespace) {
        return namespace.length == 1;
    }

    private ObjectPath objectPath(Identifier ident) throws NoSuchTableException {
        if (!this.isValidateNamespace(ident.namespace())) {
            throw new NoSuchTableException(ident);
        }
        return new ObjectPath(ident.namespace()[0], ident.name());
    }

    public void alterNamespace(String[] namespace, NamespaceChange ... changes) {
        throw new UnsupportedOperationException("Alter namespace in Spark is not supported yet.");
    }

    public void renameTable(Identifier oldIdent, Identifier newIdent) {
        throw new UnsupportedOperationException();
    }
}

