/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.table.store.file.schema.DataField;
import org.apache.flink.table.store.file.schema.DataFieldSerializer;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.store.file.utils.JsonSerializer;
import org.apache.flink.util.StringUtils;

public class SchemaSerializer
implements JsonSerializer<TableSchema> {
    public static final SchemaSerializer INSTANCE = new SchemaSerializer();

    @Override
    public void serialize(TableSchema tableSchema, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeNumberField("id", tableSchema.id());
        generator.writeArrayFieldStart("fields");
        for (DataField dataField : tableSchema.fields()) {
            DataFieldSerializer.INSTANCE.serialize(dataField, generator);
        }
        generator.writeEndArray();
        generator.writeNumberField("highestFieldId", tableSchema.highestFieldId());
        generator.writeArrayFieldStart("partitionKeys");
        for (String string : tableSchema.partitionKeys()) {
            generator.writeString(string);
        }
        generator.writeEndArray();
        generator.writeArrayFieldStart("primaryKeys");
        for (String string : tableSchema.primaryKeys()) {
            generator.writeString(string);
        }
        generator.writeEndArray();
        generator.writeObjectFieldStart("options");
        for (Map.Entry entry : tableSchema.options().entrySet()) {
            generator.writeStringField((String)entry.getKey(), (String)entry.getValue());
        }
        generator.writeEndObject();
        if (!StringUtils.isNullOrWhitespaceOnly(tableSchema.comment())) {
            generator.writeStringField("comment", tableSchema.comment());
        }
        generator.writeEndObject();
    }

    @Override
    public TableSchema deserialize(JsonNode node) {
        int id = node.get("id").asInt();
        Iterator<JsonNode> fieldJsons = node.get("fields").elements();
        ArrayList<DataField> fields = new ArrayList<DataField>();
        while (fieldJsons.hasNext()) {
            fields.add(DataFieldSerializer.INSTANCE.deserialize(fieldJsons.next()));
        }
        int highestFieldId = node.get("highestFieldId").asInt();
        Iterator<JsonNode> partitionJsons = node.get("partitionKeys").elements();
        ArrayList<String> partitionKeys = new ArrayList<String>();
        while (partitionJsons.hasNext()) {
            partitionKeys.add(partitionJsons.next().asText());
        }
        Iterator<JsonNode> primaryJsons = node.get("primaryKeys").elements();
        ArrayList<String> primaryKeys = new ArrayList<String>();
        while (primaryJsons.hasNext()) {
            primaryKeys.add(primaryJsons.next().asText());
        }
        JsonNode optionsJson = node.get("options");
        HashMap<String, String> options = new HashMap<String, String>();
        Iterator<String> optionsKeys = optionsJson.fieldNames();
        while (optionsKeys.hasNext()) {
            String key = optionsKeys.next();
            options.put(key, optionsJson.get(key).asText());
        }
        JsonNode commentNode = node.get("comment");
        String comment = "";
        if (commentNode != null) {
            comment = commentNode.asText();
        }
        return new TableSchema(id, fields, highestFieldId, partitionKeys, primaryKeys, options, comment);
    }
}

