/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.util.internal;

public class GeodeConverter {
    public static Object convertToActualType(String stringValue, String type) throws IllegalArgumentException {
        if (stringValue != null && type == null) {
            return stringValue;
        }
        Comparable<Byte> o = null;
        if (type.startsWith("java.lang.")) {
            type = type.substring(10);
        }
        if ("string".equalsIgnoreCase(type)) {
            return stringValue;
        }
        if ("char".equalsIgnoreCase(type) || "Character".equals(type)) {
            return Character.valueOf(stringValue.charAt(0));
        }
        try {
            if ("byte".equalsIgnoreCase(type)) {
                o = Byte.parseByte(stringValue);
                return o;
            }
            if ("short".equalsIgnoreCase(type)) {
                o = Short.parseShort(stringValue);
                return o;
            }
            if ("int".equalsIgnoreCase(type) || "Integer".equals(type)) {
                o = Integer.parseInt(stringValue);
                return o;
            }
            if ("long".equalsIgnoreCase(type)) {
                o = Long.parseLong(stringValue);
                return o;
            }
            if ("double".equalsIgnoreCase(type)) {
                o = Double.parseDouble(stringValue);
                return o;
            }
            if ("boolean".equalsIgnoreCase(type)) {
                o = Boolean.parseBoolean(stringValue);
                return o;
            }
            if ("float".equalsIgnoreCase(type)) {
                o = Float.valueOf(Float.parseFloat(stringValue));
                return o;
            }
            return o;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to convert input key to " + type + " Msg : " + e.getMessage());
        }
    }
}

