/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.kafka.source;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.geode.kafka.source.EventBufferSupplier;
import org.apache.geode.kafka.source.GeodeEvent;
import org.apache.geode.kafka.source.GeodeKafkaSource;

public class SharedEventBufferSupplier
implements EventBufferSupplier {
    private static BlockingQueue<GeodeEvent> eventBuffer;

    public SharedEventBufferSupplier(int size) {
        this.recreateEventBufferIfNeeded(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void recreateEventBufferIfNeeded(int size) {
        if (eventBuffer != null && eventBuffer.size() + eventBuffer.remainingCapacity() == size) return;
        Class<GeodeKafkaSource> clazz = GeodeKafkaSource.class;
        synchronized (GeodeKafkaSource.class) {
            if (eventBuffer != null && eventBuffer.size() + eventBuffer.remainingCapacity() == size) return;
            BlockingQueue<GeodeEvent> oldEventBuffer = eventBuffer;
            eventBuffer = new LinkedBlockingQueue<GeodeEvent>(size);
            if (oldEventBuffer == null) return;
            eventBuffer.addAll(oldEventBuffer);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public BlockingQueue<GeodeEvent> get() {
        return eventBuffer;
    }
}

