/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.PingHeader;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Responses;
import org.jgroups.util.Tuple;
import org.jgroups.util.UUID;

public class TCPPING
extends Discovery {
    @Property(description="Number of additional ports to be probed for membership. A port_range of 0 does not probe additional ports. Example: initial_hosts=A[7800] port_range=0 probes A:7800, port_range=1 probes A:7800 and A:7801")
    private int port_range = 1;
    @Property(name="initial_hosts", description="Comma delimited list of hosts to be contacted for initial membership", converter=PropertyConverters.InitialHosts.class, dependsUpon="port_range", systemProperty={"jgroups.tcpping.initial_hosts"})
    private List<PhysicalAddress> initial_hosts = Collections.emptyList();
    @Property(description="max number of hosts to keep beyond the ones in initial_hosts")
    protected int max_dynamic_hosts = 2000;
    protected BoundedList<PhysicalAddress> dynamic_hosts;

    @Override
    public boolean isDynamic() {
        return false;
    }

    public List<PhysicalAddress> getInitialHosts() {
        return this.initial_hosts;
    }

    public void setInitialHosts(List<PhysicalAddress> initial_hosts) {
        this.initial_hosts = initial_hosts;
    }

    public int getPortRange() {
        return this.port_range;
    }

    public void setPortRange(int port_range) {
        this.port_range = port_range;
    }

    @ManagedAttribute
    public String getDynamicHostList() {
        return this.dynamic_hosts.toString();
    }

    @ManagedOperation
    public void clearDynamicHostList() {
        this.dynamic_hosts.clear();
    }

    @ManagedAttribute
    public String getInitialHostsList() {
        return this.initial_hosts.toString();
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.dynamic_hosts = new BoundedList(this.max_dynamic_hosts);
    }

    @Override
    public Object down(Event evt) {
        Object retval = super.down(evt);
        switch (evt.getType()) {
            case 6: {
                for (Address logical_addr : this.members) {
                    PhysicalAddress physical_addr = (PhysicalAddress)this.down_prot.down(new Event(87, logical_addr));
                    if (physical_addr == null || this.initial_hosts.contains(physical_addr)) continue;
                    this.dynamic_hosts.addIfAbsent(physical_addr);
                }
                break;
            }
            case 89: {
                Tuple tuple = (Tuple)evt.getArg();
                PhysicalAddress physical_addr = (PhysicalAddress)tuple.getVal2();
                if (physical_addr == null || this.initial_hosts.contains(physical_addr)) break;
                this.dynamic_hosts.addIfAbsent(physical_addr);
            }
        }
        return retval;
    }

    @Override
    public void discoveryRequestReceived(Address sender, String logical_name, PhysicalAddress physical_addr) {
        super.discoveryRequestReceived(sender, logical_name, physical_addr);
        if (physical_addr != null && !this.initial_hosts.contains(physical_addr)) {
            this.dynamic_hosts.addIfAbsent(physical_addr);
        }
    }

    @Override
    public void findMembers(List<Address> members, boolean initial_discovery, Responses responses) {
        Collection list;
        PhysicalAddress physical_addr = (PhysicalAddress)this.down(new Event(87, this.local_addr));
        PingData data = new PingData(this.local_addr, false, UUID.get(this.local_addr), physical_addr);
        PingHeader hdr = new PingHeader(1).clusterName(this.cluster_name);
        ArrayList<PhysicalAddress> cluster_members = new ArrayList<PhysicalAddress>(this.initial_hosts.size() + (this.dynamic_hosts != null ? this.dynamic_hosts.size() : 0) + 5);
        for (PhysicalAddress physicalAddress : this.initial_hosts) {
            if (cluster_members.contains(physicalAddress)) continue;
            cluster_members.add(physicalAddress);
        }
        if (this.dynamic_hosts != null) {
            for (PhysicalAddress physicalAddress : this.dynamic_hosts) {
                if (cluster_members.contains(physicalAddress)) continue;
                cluster_members.add(physicalAddress);
            }
        }
        if (this.use_disk_cache && (list = (Collection)this.down_prot.down(new Event(102))) != null) {
            for (PhysicalAddress phys_addr : list) {
                if (cluster_members.contains(phys_addr)) continue;
                cluster_members.add(phys_addr);
            }
        }
        for (PhysicalAddress physicalAddress : cluster_members) {
            if (physical_addr != null && physicalAddress.equals(physical_addr)) continue;
            final Message msg = new Message(physicalAddress).setFlag(Message.Flag.INTERNAL, Message.Flag.DONT_BUNDLE, Message.Flag.OOB).putHeader(this.id, hdr).setBuffer(TCPPING.marshal(data));
            if (this.async_discovery_use_separate_thread_per_request) {
                this.timer.execute(new Runnable(){

                    @Override
                    public void run() {
                        TCPPING.this.log.trace("%s: sending discovery request to %s", TCPPING.this.local_addr, msg.getDest());
                        TCPPING.this.down_prot.down(new Event(1, msg));
                    }
                });
                continue;
            }
            this.log.trace("%s: sending discovery request to %s", this.local_addr, msg.getDest());
            this.down_prot.down(new Event(1, msg));
        }
    }
}

