/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio;

import com.healthmarketscience.rmiio.RemoteOutputStreamClient;
import com.healthmarketscience.rmiio.RemoteOutputStreamServer;
import com.healthmarketscience.rmiio.RemoteStreamMonitor;
import com.healthmarketscience.rmiio.util.PipeBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GZIPRemoteOutputStream
extends RemoteOutputStreamServer {
    private static final long serialVersionUID = 20080212L;
    private final transient PipeBuffer.InputStreamAdapter _packetIStream = new PipeBuffer.InputStreamAdapter(RemoteOutputStreamClient.DEFAULT_CHUNK_SIZE);
    private transient GZIPInputStream _gzipIStream;
    private final transient byte[] _transferBuf;
    private transient boolean _outEOF = false;

    public GZIPRemoteOutputStream(OutputStream out) {
        this(out, DUMMY_MONITOR);
    }

    public GZIPRemoteOutputStream(OutputStream out, RemoteStreamMonitor<RemoteOutputStreamServer> monitor) {
        super(out, monitor);
        this._packetIStream.createPipeBuffer();
        this._transferBuf = new byte[RemoteOutputStreamClient.DEFAULT_CHUNK_SIZE * 2];
    }

    @Override
    public boolean usingGZIPCompression() {
        return true;
    }

    private void flushPacket(int maxReadLen, boolean finish) throws IOException {
        int totRead = 0;
        int readLen = maxReadLen;
        while (!this._outEOF && (this._packetIStream.available() > 0 || finish)) {
            int numRead;
            if (totRead + readLen > this._transferBuf.length) {
                readLen = this._transferBuf.length - totRead;
            }
            if ((numRead = this._gzipIStream.read(this._transferBuf, totRead, readLen)) > 0) {
                if ((totRead += numRead) != this._transferBuf.length) continue;
                totRead = 0;
                readLen = maxReadLen;
                this._out.write(this._transferBuf, 0, this._transferBuf.length);
                this._monitor.localBytesMoved(this, this._transferBuf.length);
                continue;
            }
            this._outEOF = true;
        }
        if (totRead > 0) {
            this._out.write(this._transferBuf, 0, totRead);
            this._monitor.localBytesMoved(this, totRead);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeImpl(boolean writeSuccess) throws IOException {
        if (writeSuccess) {
            Object object = this.getLock();
            synchronized (object) {
                block7: {
                    try {
                        if (this._gzipIStream != null) {
                            this.flushPacket(this._transferBuf.length, true);
                        }
                    }
                    catch (IOException ignored) {
                        if (!LOG.isDebugEnabled()) break block7;
                        LOG.debug((Object)"Ignoring exception while flushing stream", (Throwable)ignored);
                    }
                }
            }
        }
        super.closeImpl(writeSuccess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flushImpl() throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            this._out.flush();
        }
    }

    @Override
    protected void writePacket(byte[] packet) throws IOException {
        this._packetIStream.getBuffer().writePacket(packet, 0, packet.length);
        if (this._gzipIStream == null) {
            this._gzipIStream = new GZIPInputStream((InputStream)this._packetIStream, RemoteOutputStreamClient.DEFAULT_CHUNK_SIZE);
        }
        this.flushPacket(1, false);
    }
}

