/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.geode.management.configuration.ClassName;
import org.apache.geode.management.configuration.GroupableConfiguration;
import org.apache.geode.management.configuration.Links;
import org.apache.geode.management.configuration.RegionType;
import org.apache.geode.management.runtime.RuntimeRegionInfo;

public class Region
extends GroupableConfiguration<RuntimeRegionInfo> {
    public static final String REGION_CONFIG_ENDPOINT = "/regions";
    private String name;
    private RegionType type;
    private String keyConstraint;
    private String valueConstraint;
    private String diskStoreName;
    private Integer redundantCopies;
    private List<Expiration> expirations;
    private Eviction eviction;

    @Override
    public boolean isGlobalRuntime() {
        return true;
    }

    @Override
    public Links getLinks() {
        Links links = new Links(this.getId(), REGION_CONFIG_ENDPOINT);
        links.addLink("indexes", links.getSelf() + "/indexes");
        return links;
    }

    @Override
    @JsonIgnore
    public String getId() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        boolean hasSubRegions;
        if (value == null) {
            this.name = null;
            return;
        }
        boolean regionPrefixedWithSlash = value.startsWith("/");
        String[] regionSplit = value.split("/");
        boolean bl = regionPrefixedWithSlash ? regionSplit.length > 2 : (hasSubRegions = regionSplit.length > 1);
        if (hasSubRegions) {
            throw new IllegalArgumentException("Sub-regions are unsupported");
        }
        this.name = regionPrefixedWithSlash ? regionSplit[1] : value;
    }

    public RegionType getType() {
        return this.type;
    }

    public void setType(RegionType type) {
        this.type = type;
    }

    public Integer getRedundantCopies() {
        return this.redundantCopies;
    }

    public void setRedundantCopies(Integer redundantCopies) {
        this.redundantCopies = redundantCopies;
    }

    public String getKeyConstraint() {
        return this.keyConstraint;
    }

    public void setKeyConstraint(String keyConstraint) {
        this.keyConstraint = keyConstraint;
    }

    public String getValueConstraint() {
        return this.valueConstraint;
    }

    public void setValueConstraint(String valueConstraint) {
        this.valueConstraint = valueConstraint;
    }

    public String getDiskStoreName() {
        return this.diskStoreName;
    }

    public void setDiskStoreName(String diskStoreName) {
        this.diskStoreName = diskStoreName;
    }

    public List<Expiration> getExpirations() {
        return this.expirations;
    }

    public void setExpirations(List<Expiration> expirations) {
        if (expirations == null) {
            this.expirations = null;
            return;
        }
        this.expirations = expirations.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Eviction getEviction() {
        return this.eviction;
    }

    public void setEviction(Eviction eviction) {
        this.eviction = eviction;
    }

    public void addExpiry(ExpirationType type, Integer timeout, ExpirationAction action) {
        if (this.expirations == null) {
            this.expirations = new ArrayList<Expiration>();
        }
        this.expirations.add(new Expiration(type, timeout, action));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Region region = (Region)o;
        return Objects.equals(this.name, region.name) && this.type == region.type && Objects.equals(this.keyConstraint, region.keyConstraint) && Objects.equals(this.valueConstraint, region.valueConstraint) && Objects.equals(this.diskStoreName, region.diskStoreName) && Objects.equals(this.redundantCopies, region.redundantCopies) && Objects.equals(this.expirations, region.expirations) && Objects.equals(this.eviction, region.eviction);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.name, this.type, this.keyConstraint, this.valueConstraint, this.diskStoreName, this.redundantCopies, this.expirations, this.eviction});
    }

    public String toString() {
        return "Region{name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + ", keyConstraint='" + this.keyConstraint + '\'' + ", valueConstraint='" + this.valueConstraint + '\'' + ", diskStoreName='" + this.diskStoreName + '\'' + ", redundantCopies=" + this.redundantCopies + ", expirations=" + this.expirations + ", eviction=" + this.eviction + "} " + super.toString();
    }

    public static class Eviction
    implements Serializable {
        private EvictionType type;
        private EvictionAction action;
        private Integer limit;
        private ClassName objectSizer;

        public EvictionType getType() {
            return this.type;
        }

        public void setType(EvictionType type) {
            if (this.type != null && this.type != type) {
                throw new IllegalArgumentException("Type conflict. Type is already set to " + (Object)((Object)this.type));
            }
            this.type = type;
        }

        public EvictionAction getAction() {
            return this.action;
        }

        public void setAction(EvictionAction action) {
            this.action = action;
        }

        public Integer getEntryCount() {
            if (this.type == EvictionType.ENTRY_COUNT) {
                return this.limit;
            }
            return null;
        }

        public void setEntryCount(Integer entryCount) {
            if (this.type != null && this.type != EvictionType.ENTRY_COUNT) {
                throw new IllegalArgumentException("Type conflict. Type is already set to " + (Object)((Object)this.type));
            }
            this.type = EvictionType.ENTRY_COUNT;
            this.limit = entryCount;
        }

        public Integer getMemorySizeMb() {
            if (this.type == EvictionType.MEMORY_SIZE) {
                return this.limit;
            }
            return null;
        }

        public void setMemorySizeMb(Integer memorySizeMb) {
            if (this.type != null && this.type != EvictionType.MEMORY_SIZE) {
                throw new IllegalArgumentException("Type conflict. type is already set to " + (Object)((Object)this.type));
            }
            this.type = EvictionType.MEMORY_SIZE;
            this.limit = memorySizeMb;
        }

        public ClassName getObjectSizer() {
            return this.objectSizer;
        }

        public void setObjectSizer(ClassName objectSizer) {
            this.objectSizer = objectSizer;
        }
    }

    public static enum EvictionAction {
        LOCAL_DESTROY,
        OVERFLOW_TO_DISK;

    }

    public static enum EvictionType {
        ENTRY_COUNT,
        MEMORY_SIZE,
        HEAP_PERCENTAGE;

    }

    public static class Expiration
    implements Serializable {
        private ExpirationType type;
        private Integer timeInSeconds;
        private ExpirationAction action;

        public Expiration() {
        }

        public Expiration(ExpirationType type, Integer timeInSeconds, ExpirationAction action) {
            this.setType(type);
            this.timeInSeconds = timeInSeconds;
            this.action = action;
        }

        public ExpirationType getType() {
            return this.type;
        }

        public void setType(ExpirationType type) {
            this.type = type;
        }

        public Integer getTimeInSeconds() {
            return this.timeInSeconds;
        }

        public void setTimeInSeconds(Integer timeInSeconds) {
            this.timeInSeconds = timeInSeconds;
        }

        public ExpirationAction getAction() {
            return this.action;
        }

        public void setAction(ExpirationAction action) {
            this.action = action;
        }
    }

    public static enum ExpirationAction {
        DESTROY,
        INVALIDATE,
        LEGACY;

    }

    public static enum ExpirationType {
        ENTRY_TIME_TO_LIVE,
        ENTRY_IDLE_TIME,
        LEGACY;

    }
}

