/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin;

import java.io.File;
import java.net.InetAddress;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.apache.geode.admin.AdminException;
import org.apache.geode.admin.AlertLevel;
import org.apache.geode.admin.AlertListener;
import org.apache.geode.admin.BackupStatus;
import org.apache.geode.admin.CacheServer;
import org.apache.geode.admin.CacheVm;
import org.apache.geode.admin.DistributedSystemConfig;
import org.apache.geode.admin.DistributionLocator;
import org.apache.geode.admin.GemFireHealth;
import org.apache.geode.admin.SystemMember;
import org.apache.geode.admin.SystemMemberCacheListener;
import org.apache.geode.admin.SystemMembershipListener;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.distributed.DistributedMember;

public interface AdminDistributedSystem {
    public String getId();

    public String getName();

    public String getRemoteCommand();

    public void setRemoteCommand(String var1);

    public void setAlertLevel(AlertLevel var1);

    public AlertLevel getAlertLevel();

    public void setAlertLevelAsString(String var1);

    public String getAlertLevelAsString();

    public void addAlertListener(AlertListener var1);

    public void removeAlertListener(AlertListener var1);

    public String getMcastAddress();

    public int getMcastPort();

    public String getLocators();

    public boolean isMcastEnabled();

    public boolean isRunning();

    public boolean isConnected();

    public void start() throws AdminException;

    public void stop() throws AdminException;

    public String displayMergedLogs();

    public Properties getLicense();

    public DistributionLocator addDistributionLocator();

    public DistributionLocator[] getDistributionLocators();

    public SystemMember[] getSystemMemberApplications() throws AdminException;

    public String getLatestAlert();

    public GemFireHealth getGemFireHealth();

    public void connect();

    public boolean waitToBeConnected(long var1) throws InterruptedException;

    public void disconnect();

    public DistributedSystemConfig getConfig();

    public void addMembershipListener(SystemMembershipListener var1);

    public void removeMembershipListener(SystemMembershipListener var1);

    public void addCacheListener(SystemMemberCacheListener var1);

    public void removeCacheListener(SystemMemberCacheListener var1);

    @Deprecated
    public CacheServer addCacheServer() throws AdminException;

    @Deprecated
    public CacheServer[] getCacheServers() throws AdminException;

    public CacheServer[] getCacheServers(String var1) throws AdminException;

    public CacheVm addCacheVm() throws AdminException;

    public CacheVm[] getCacheVms() throws AdminException;

    public SystemMember lookupSystemMember(DistributedMember var1) throws AdminException;

    public void revokePersistentMember(InetAddress var1, String var2) throws AdminException;

    public void revokePersistentMember(UUID var1) throws AdminException;

    public Set<PersistentID> getMissingPersistentMembers() throws AdminException;

    public Set<DistributedMember> shutDownAllMembers() throws AdminException;

    public Set<DistributedMember> shutDownAllMembers(long var1) throws AdminException;

    public BackupStatus backupAllMembers(File var1) throws AdminException;

    public BackupStatus backupAllMembers(File var1, File var2) throws AdminException;

    public Map<DistributedMember, Set<PersistentID>> compactAllDiskStores() throws AdminException;
}

