/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.DiskWriteAttributesFactory;
import org.apache.geode.cache.DynamicRegionListener;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.PartitionAttributesFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.internal.ServerRegionProxy;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.DynamicRegionAttributes;
import org.apache.geode.internal.cache.DynamicRegionFactoryImpl;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EvictionAttributesImpl;
import org.apache.geode.internal.cache.InitialImageOperation;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEventImpl;
import org.apache.geode.security.GemFireSecurityException;

@Deprecated
public abstract class DynamicRegionFactory {
    public static final String DYNAMIC_REGION_LIST_NAME = "__DynamicRegions";
    private Region dynamicRegionList = null;
    private static final long regionCreateSleepMillis = Long.getLong("DynamicRegionFactory.msDelay", 250L);
    @MakeNotStatic
    private static final DynamicRegionFactory singleInstance = new DynamicRegionFactoryImpl();
    InternalCache cache = null;
    private Config config = null;
    @MakeNotStatic
    private static volatile List regionListeners = Collections.emptyList();
    private static final Object regionListenerLock = new Object();

    public void open() {
        this.open(new Config());
    }

    public void open(Config conf) {
        this.config = new Config(conf);
    }

    protected void doClose() {
        this.config = null;
        this.cache = null;
    }

    public boolean isOpen() {
        return this.getConfig() != null;
    }

    public boolean isActive() {
        return this.isOpen() && this.cache != null;
    }

    public boolean isClosed() {
        return !this.isOpen();
    }

    public Config getConfig() {
        if (this.config == null) {
            return null;
        }
        return new Config(this.config);
    }

    public static boolean regionIsDynamicRegionList(String regionPath) {
        return regionPath != null && regionPath.equals("/__DynamicRegions");
    }

    protected void doInternalInit(InternalCache theCache) throws CacheException {
        if (this.isClosed()) {
            return;
        }
        try {
            boolean isClient;
            this.cache = theCache;
            this.dynamicRegionList = theCache.getRegion(DYNAMIC_REGION_LIST_NAME);
            boolean bl = isClient = this.config.getPoolName() != null;
            if (this.dynamicRegionList == null) {
                InternalRegionArguments ira = new InternalRegionArguments().setDestroyLockFlag(true).setInternalRegion(true).setSnapshotInputStream(null).setImageTarget(null);
                AttributesFactory af = new AttributesFactory();
                if (this.config.getPersistBackup()) {
                    af.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    af.setDiskWriteAttributes(new DiskWriteAttributesFactory().create());
                    if (this.config.getDiskDir() != null) {
                        af.setDiskDirs(new File[]{this.config.getDiskDir()});
                    }
                }
                if (isClient) {
                    af.setScope(Scope.LOCAL);
                    af.setDataPolicy(DataPolicy.NORMAL);
                    af.setStatisticsEnabled(true);
                    String cpName = this.config.getPoolName();
                    if (cpName != null) {
                        Pool cp = PoolManager.find(cpName);
                        if (cp == null) {
                            throw new IllegalStateException("Invalid pool name specified. This pool is not registered with the cache: " + (String)cpName);
                        }
                        if (!cp.getSubscriptionEnabled()) {
                            throw new IllegalStateException("The client pool of a DynamicRegionFactory must be configured with queue-enabled set to true.");
                        }
                        af.setPoolName(cpName);
                    }
                    ira.setInternalMetaRegion(new LocalMetaRegion(af.create(), ira));
                } else {
                    af.setScope(Scope.DISTRIBUTED_ACK);
                    af.setValueConstraint(DynamicRegionAttributes.class);
                    if (!this.config.getPersistBackup()) {
                        af.setDataPolicy(DataPolicy.REPLICATE);
                    }
                    for (GatewaySender gs : this.cache.getGatewaySenders()) {
                        if (gs.isParallel()) continue;
                        af.addGatewaySenderId(gs.getId());
                    }
                    ira.setInternalMetaRegion(new DistributedMetaRegion(af.create()));
                }
                try {
                    this.dynamicRegionList = theCache.createVMRegion(DYNAMIC_REGION_LIST_NAME, af.create(), ira);
                }
                catch (IOException e) {
                    throw new InternalGemFireError("unexpected exception", e);
                }
                catch (ClassNotFoundException e) {
                    throw new InternalGemFireError("unexpected exception", e);
                }
                if (isClient) {
                    this.dynamicRegionList.registerInterest("ALL_KEYS");
                }
                if (theCache.getLogger().fineEnabled()) {
                    theCache.getLogger().fine("Created dynamic region: " + this.dynamicRegionList);
                }
            } else if (theCache.getLogger().fineEnabled()) {
                theCache.getLogger().fine("Retrieved dynamic region: " + this.dynamicRegionList);
            }
            this.createDefinedDynamicRegions();
        }
        catch (CacheException e) {
            theCache.getLogger().warning("Error initializing DynamicRegionFactory", e);
            throw e;
        }
    }

    private void createDefinedDynamicRegions() throws CacheException {
        Set<Region.Entry<?, ?>> set = this.dynamicRegionList.entrySet(false);
        Iterator<Region.Entry<Object, Object>> iterator = set.iterator();
        TreeMap<String, DynamicRegionAttributes> sorted = new TreeMap<String, DynamicRegionAttributes>();
        while (iterator.hasNext()) {
            Region.Entry<?, ?> e = iterator.next();
            DynamicRegionAttributes dda = (DynamicRegionAttributes)e.getValue();
            sorted.put(dda.rootRegionName + '/' + dda.name, dda);
        }
        for (DynamicRegionAttributes dda : sorted.values()) {
            this.doBeforeRegionCreated(dda.rootRegionName, dda.name);
            Region region = this.createDynamicRegionImpl(dda.rootRegionName, dda.name, false);
            this.doAfterRegionCreated(region, false, false, null);
        }
    }

    public static DynamicRegionFactory get() {
        return singleInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDynamicRegionListener(DynamicRegionListener listener) {
        Object object = regionListenerLock;
        synchronized (object) {
            List oldListeners = regionListeners;
            if (!oldListeners.contains(listener)) {
                ArrayList<DynamicRegionListener> newListeners = new ArrayList<DynamicRegionListener>(oldListeners);
                newListeners.add(listener);
                regionListeners = newListeners;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterDynamicRegionListener(DynamicRegionListener listener) {
        Object object = regionListenerLock;
        synchronized (object) {
            ArrayList newListeners;
            List oldListeners = regionListeners;
            if (oldListeners.contains(listener) && (newListeners = new ArrayList(oldListeners)).remove(listener)) {
                regionListeners = newListeners;
            }
        }
    }

    private void doBeforeRegionCreated(String parentRegion, String regionName) {
        for (Object regionListener : regionListeners) {
            DynamicRegionListener listener = (DynamicRegionListener)regionListener;
            try {
                listener.beforeRegionCreate(parentRegion, regionName);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                this.cache.getLogger().warning(String.format("DynamicRegionListener %s threw exception on beforeRegionCreated", listener), t);
            }
        }
    }

    private void doAfterRegionCreated(Region region, boolean distributed, boolean isOriginRemote, DistributedMember mbr) {
        RegionEventImpl event = new RegionEventImpl(region, Operation.REGION_CREATE, null, isOriginRemote, this.getMember(mbr));
        for (Object regionListener : regionListeners) {
            DynamicRegionListener listener = (DynamicRegionListener)regionListener;
            try {
                listener.afterRegionCreate(event);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                this.cache.getLogger().warning(String.format("DynamicRegionListener %s threw exception on afterRegionCreated", listener), t);
            }
        }
    }

    private void doBeforeRegionDestroyed(Region region, boolean distributed, boolean isOriginRemote, boolean expiration, DistributedMember mbr) {
        Operation op = !distributed && !isOriginRemote ? (expiration ? Operation.REGION_EXPIRE_LOCAL_DESTROY : Operation.REGION_LOCAL_DESTROY) : (expiration ? Operation.REGION_EXPIRE_DESTROY : Operation.REGION_DESTROY);
        RegionEventImpl event = new RegionEventImpl(region, op, null, isOriginRemote, this.getMember(mbr));
        for (Object regionListener : regionListeners) {
            DynamicRegionListener listener = (DynamicRegionListener)regionListener;
            try {
                listener.beforeRegionDestroy(event);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                this.cache.getLogger().warning(String.format("DynamicRegionListener %s threw exception on beforeRegionDestroyed", listener), t);
            }
        }
    }

    private void doAfterRegionDestroyed(Region region, boolean distributed, boolean isOriginRemote, boolean expiration, DistributedMember mbr) {
        Operation op = !distributed && !isOriginRemote ? (expiration ? Operation.REGION_EXPIRE_LOCAL_DESTROY : Operation.REGION_LOCAL_DESTROY) : (expiration ? Operation.REGION_EXPIRE_DESTROY : Operation.REGION_DESTROY);
        RegionEventImpl event = new RegionEventImpl(region, op, null, isOriginRemote, this.getMember(mbr));
        for (Object regionListener : regionListeners) {
            DynamicRegionListener listener = (DynamicRegionListener)regionListener;
            try {
                listener.afterRegionDestroy(event);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                this.cache.getLogger().warning(String.format("DynamicRegionListener %s threw exception on afterRegionDestroyed", listener), t);
            }
        }
    }

    private DistributedMember getMember(DistributedMember mbr) {
        if (mbr == null) {
            return this.cache.getInternalDistributedSystem().getDistributedMember();
        }
        return null;
    }

    public Region createDynamicRegion(String parentRegionName, String regionName) throws CacheException {
        if (this.isClosed()) {
            throw new IllegalStateException("Dynamic region factory is closed");
        }
        this.doBeforeRegionCreated(parentRegionName, regionName);
        Region region = this.createDynamicRegionImpl(parentRegionName, regionName, true);
        this.doAfterRegionCreated(region, false, false, null);
        return region;
    }

    public void destroyDynamicRegion(String fullRegionName) throws CacheException {
        if (!this.dynamicRegionList.containsKey(fullRegionName)) {
            throw new RegionDestroyedException(String.format("Dynamic region %s has not been created.", fullRegionName), fullRegionName);
        }
        if (this.isClosed()) {
            throw new IllegalStateException("Dynamic region factory is closed");
        }
        Region region = this.cache.getRegion(fullRegionName);
        if (region != null) {
            DistributedMember mbr = this.getMember(null);
            this.doBeforeRegionDestroyed(region, false, false, false, mbr);
            region.localDestroyRegion();
            this.destroyDynamicRegionImpl(fullRegionName);
            this.doAfterRegionDestroyed(region, false, false, false, mbr);
        } else {
            this.destroyDynamicRegionImpl(fullRegionName);
        }
    }

    private Region createDynamicRegionImpl(String parentRegionName, String newRegionName, boolean addEntry) throws CacheException {
        ServerRegionProxy proxy;
        Region newRegion;
        Region parentRegion = this.cache.getRegion(parentRegionName);
        if (parentRegion == null) {
            String errMsg = String.format("Error -- Could not find a region named: '%s'", parentRegionName);
            RegionDestroyedException e = new RegionDestroyedException(errMsg, parentRegionName);
            this.cache.getLogger().warning(String.format("Error -- Could not find a region named: '%s'", parentRegionName), e);
            throw e;
        }
        RegionAttributes rra = parentRegion.getAttributes();
        AttributesFactory af = new AttributesFactory(rra);
        EvictionAttributes ev = rra.getEvictionAttributes();
        if (ev != null && ev.getAlgorithm().isLRU()) {
            EvictionAttributesImpl rev = new EvictionAttributesImpl(ev);
            af.setEvictionAttributes(rev);
        }
        if (newRegionName.endsWith("_PRTEST_")) {
            af.setPartitionAttributes(new PartitionAttributesFactory().create());
        }
        RegionAttributes newRegionAttributes = af.create();
        try {
            newRegion = parentRegion.createSubregion(newRegionName, newRegionAttributes);
            this.cache.getLogger().fine("Created dynamic region " + newRegion);
        }
        catch (RegionExistsException ex) {
            this.cache.getLogger().fine("DynamicRegion " + newRegionName + " in parent " + parentRegionName + " already existed");
            newRegion = ex.getRegion();
        }
        if (addEntry) {
            DynamicRegionAttributes dra = new DynamicRegionAttributes();
            dra.name = newRegionName;
            dra.rootRegionName = parentRegion.getFullPath();
            if (this.cache.getLogger().fineEnabled()) {
                this.cache.getLogger().fine("Putting entry into dynamic region list at key: " + newRegion.getFullPath());
            }
            this.dynamicRegionList.put(newRegion.getFullPath(), dra);
        }
        if (this.config.getRegisterInterest() && (proxy = ((InternalRegion)newRegion).getServerProxy()) != null && proxy.getPool().getSubscriptionEnabled()) {
            try {
                newRegion.registerInterest("ALL_KEYS");
            }
            catch (GemFireSecurityException ex) {
                this.cache.getSecurityLogger().warning(String.format("Exception when registering interest for all keys in dynamic region [%s]. %s", newRegion.getFullPath(), ex));
            }
        }
        if (regionCreateSleepMillis > 0L) {
            try {
                Thread.sleep(regionCreateSleepMillis);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.cache.getLogger().fineEnabled()) {
            this.cache.getLogger().fine("Created Dynamic Region " + newRegion.getFullPath());
        }
        return newRegion;
    }

    private void destroyDynamicRegionImpl(String fullRegionName) throws CacheException {
        try {
            if (this.cache.getLogger().fineEnabled()) {
                this.cache.getLogger().fine("Destroying entry from dynamic region list at key: " + fullRegionName);
            }
            this.dynamicRegionList.destroy(fullRegionName);
        }
        catch (CacheException e) {
            this.cache.getLogger().warning(String.format("Error destroying Dynamic Region '%s'", fullRegionName), e);
            throw e;
        }
        if (this.cache.getLogger().fineEnabled()) {
            this.cache.getLogger().fine("Destroyed Dynamic Region " + fullRegionName);
        }
    }

    protected void buildDynamicRegion(EntryEvent event) {
        if (!this.isOpen()) {
            return;
        }
        if (!event.isOriginRemote() && !event.hasClientOrigin()) {
            return;
        }
        DynamicRegionAttributes dra = (DynamicRegionAttributes)event.getNewValue();
        String parentRegionName = dra.rootRegionName;
        String newRegionName = dra.name;
        try {
            this.doBeforeRegionCreated(parentRegionName, newRegionName);
            Region region = this.createDynamicRegionImpl(parentRegionName, newRegionName, false);
            this.doAfterRegionCreated(region, true, true, event.getDistributedMember());
        }
        catch (Exception e) {
            this.cache.getLogger().warning(String.format("Error attempting to locally create Dynamic Region: %s", newRegionName), e);
        }
    }

    protected void razeDynamicRegion(EntryEvent event) {
        if (!this.isOpen()) {
            return;
        }
        String fullRegionName = (String)event.getKey();
        Region drRegion = this.cache.getRegion(fullRegionName);
        if (drRegion != null) {
            try {
                this.doBeforeRegionDestroyed(drRegion, true, event.getOperation().isDistributed(), event.getOperation().isExpiration(), event.getDistributedMember());
                drRegion.localDestroyRegion();
                this.doAfterRegionDestroyed(drRegion, true, event.getOperation().isDistributed(), event.getOperation().isExpiration(), event.getDistributedMember());
            }
            catch (Exception e) {
                this.cache.getLogger().warning(String.format("Error attempting to locally destroy Dynamic Region: %s", fullRegionName), e);
            }
        }
    }

    private class DistributedMetaRegion
    extends DistributedRegion {
        protected DistributedMetaRegion(RegionAttributes attrs) {
            super(DynamicRegionFactory.DYNAMIC_REGION_LIST_NAME, attrs, null, DynamicRegionFactory.this.cache, new InternalRegionArguments(), DynamicRegionFactory.this.cache.getStatisticsClock());
        }

        @Override
        public boolean isSecret() {
            return true;
        }

        @Override
        public boolean isCopyOnRead() {
            return false;
        }

        @Override
        public boolean shouldNotifyBridgeClients() {
            return this.getCache().getCacheServers().size() > 0;
        }

        @Override
        public void invokeDestroyCallbacks(EnumListenerEvent eventType, EntryEventImpl event, boolean callDispatchEventsCallback, boolean notifyGateways) {
            Assert.assertTrue(eventType.equals(EnumListenerEvent.AFTER_DESTROY));
            event.setEventType(eventType);
            this.notifyBridgeClients(event);
            if (notifyGateways) {
                this.notifyGatewaySender(eventType, event);
            }
            DynamicRegionFactory.this.razeDynamicRegion(event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long basicPutPart2(EntryEventImpl event, RegionEntry entry, boolean isInitialized, long lastModified, boolean clearConflict) {
            boolean isCreate = event.getOperation().isCreate();
            boolean set = false;
            if (isCreate && !event.callbacksInvoked()) {
                event.callbacksInvoked(true);
                set = true;
            }
            long result = super.basicPutPart2(event, entry, isInitialized, lastModified, clearConflict);
            if (set) {
                event.callbacksInvoked(false);
            }
            if (isCreate) {
                try {
                    InitialImageOperation.setInhibitStateFlush(true);
                    DynamicRegionFactory.this.buildDynamicRegion(event);
                }
                finally {
                    InitialImageOperation.setInhibitStateFlush(false);
                }
            }
            return result;
        }

        @Override
        public void basicPutPart3(EntryEventImpl event, RegionEntry entry, boolean isInitialized, long lastModified, boolean invokeCallbacks, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue) {
            super.basicPutPart3(event, entry, isInitialized, lastModified, invokeCallbacks, ifNew, ifOld, expectedOldValue, requireOldValue);
            if (invokeCallbacks &= !entry.isTombstone()) {
                boolean doCallback = false;
                if (isInitialized && event.isGenerateCallbacks()) {
                    doCallback = true;
                }
                if (doCallback) {
                    this.notifyGatewaySender(event.getOperation().isUpdate() ? EnumListenerEvent.AFTER_UPDATE : EnumListenerEvent.AFTER_CREATE, event);
                    if (!event.isBulkOpInProgress()) {
                        try {
                            entry.dispatchListenerEvents(event);
                        }
                        catch (InterruptedException ignore) {
                            Thread.currentThread().interrupt();
                            this.getCancelCriterion().checkCancelInProgress(null);
                        }
                    }
                }
            }
        }
    }

    private class LocalMetaRegion
    extends LocalRegion {
        protected LocalMetaRegion(RegionAttributes attrs, InternalRegionArguments ira) {
            super(DynamicRegionFactory.DYNAMIC_REGION_LIST_NAME, attrs, null, DynamicRegionFactory.this.cache, ira, DynamicRegionFactory.this.cache.getStatisticsClock());
            Assert.assertTrue(attrs.getScope().isLocal());
        }

        @Override
        public boolean isSecret() {
            return true;
        }

        @Override
        public boolean isCopyOnRead() {
            return false;
        }

        @Override
        public boolean shouldNotifyBridgeClients() {
            return this.getCache().getCacheServers().size() > 0;
        }

        @Override
        public void invokeDestroyCallbacks(EnumListenerEvent eventType, EntryEventImpl event, boolean callDispatchEventsCallback, boolean notifyGateways) {
            Assert.assertTrue(eventType.equals(EnumListenerEvent.AFTER_DESTROY));
            event.setEventType(eventType);
            this.notifyBridgeClients(event);
            if (notifyGateways) {
                this.notifyGatewaySender(eventType, event);
            }
            DynamicRegionFactory.this.razeDynamicRegion(event);
        }

        @Override
        public long basicPutPart2(EntryEventImpl event, RegionEntry entry, boolean isInitialized, long lastModified, boolean clearConflict) {
            boolean isCreate = event.getOperation().isCreate();
            boolean set = false;
            if (isCreate && !event.callbacksInvoked()) {
                event.callbacksInvoked(true);
                set = true;
            }
            long result = super.basicPutPart2(event, entry, isInitialized, lastModified, clearConflict);
            if (set) {
                event.callbacksInvoked(false);
            }
            if (isCreate) {
                DynamicRegionFactory.this.buildDynamicRegion(event);
            }
            return result;
        }

        @Override
        public void basicPutPart3(EntryEventImpl event, RegionEntry entry, boolean isInitialized, long lastModified, boolean invokeCallbacks, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue) {
            super.basicPutPart3(event, entry, isInitialized, lastModified, invokeCallbacks, ifNew, ifOld, expectedOldValue, requireOldValue);
            if (invokeCallbacks &= !entry.isTombstone()) {
                boolean doCallback = false;
                if (isInitialized && event.isGenerateCallbacks()) {
                    doCallback = true;
                }
                if (doCallback) {
                    this.notifyGatewaySender(event.getOperation().isUpdate() ? EnumListenerEvent.AFTER_UPDATE : EnumListenerEvent.AFTER_CREATE, event);
                    if (!event.isBulkOpInProgress()) {
                        try {
                            entry.dispatchListenerEvents(event);
                        }
                        catch (InterruptedException ignore) {
                            Thread.currentThread().interrupt();
                            this.getCancelCriterion().checkCancelInProgress(null);
                        }
                    }
                }
            }
        }
    }

    public static class Config {
        private static final boolean DISABLE_REGISTER_INTEREST = Boolean.getBoolean("DynamicRegionFactory.disableRegisterInterest");
        private static final boolean DISABLE_PERSIST_BACKUP = Boolean.getBoolean("DynamicRegionFactory.disablePersistence");
        public final boolean persistBackup;
        public final File diskDir;
        public final boolean registerInterest;
        public final String poolName;

        public Config() {
            this(null, null, !DISABLE_PERSIST_BACKUP, !DISABLE_REGISTER_INTEREST);
        }

        public Config(File diskDir, String poolName) {
            this(diskDir, poolName, !DISABLE_PERSIST_BACKUP, !DISABLE_REGISTER_INTEREST);
        }

        public Config(File diskDir, String poolName, boolean persistBackup, boolean registerInterest) {
            this.registerInterest = registerInterest;
            this.persistBackup = persistBackup;
            this.diskDir = diskDir;
            this.poolName = poolName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.diskDir == null ? 0 : this.diskDir.hashCode());
            result = 31 * result + (this.persistBackup ? 1231 : 1237);
            result = 31 * result + (this.poolName == null ? 0 : this.poolName.hashCode());
            result = 31 * result + (this.registerInterest ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Config other = (Config)obj;
            if (this.diskDir == null ? other.diskDir != null : !this.diskDir.equals(other.diskDir)) {
                return false;
            }
            if (this.persistBackup != other.persistBackup) {
                return false;
            }
            if (this.poolName == null ? other.poolName != null : !this.poolName.equals(other.poolName)) {
                return false;
            }
            return this.registerInterest == other.registerInterest;
        }

        public boolean getPersistBackup() {
            return this.persistBackup;
        }

        public boolean getRegisterInterest() {
            return this.registerInterest;
        }

        public File getDiskDir() {
            return this.diskDir;
        }

        public String getPoolName() {
            return this.poolName;
        }

        Config(Config conf) {
            this.diskDir = conf.diskDir;
            this.persistBackup = conf.persistBackup;
            this.registerInterest = conf.registerInterest;
            this.poolName = conf.poolName;
        }
    }
}

