/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache;

import java.util.Collections;
import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.distributed.Role;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.InternalRegion;

public class RequiredRoles {
    public static Set<Role> checkForRequiredRoles(Region<?, ?> region) {
        try {
            return RequiredRoles.waitForRequiredRoles(region, 0L);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            ((InternalRegion)region).getCancelCriterion().checkCancelInProgress(ie);
            Assert.assertTrue(false, "checkForRequiredRoles cannot throw InterruptedException");
            return Collections.emptySet();
        }
    }

    public static Set<Role> waitForRequiredRoles(Region<?, ?> region, long timeout) throws InterruptedException {
        if (region == null) {
            throw new NullPointerException("Region must be specified");
        }
        if (!(region instanceof DistributedRegion)) {
            throw new IllegalStateException("Region has not been configured with required roles.");
        }
        DistributedRegion dr = (DistributedRegion)region;
        return dr.waitForRequiredRoles(timeout);
    }

    public static boolean isRoleInRegionMembership(Region<?, ?> region, Role role) {
        if (region instanceof DistributedRegion) {
            DistributedRegion dr = (DistributedRegion)region;
            return dr.isRoleInRegionMembership(role);
        }
        return role.isPresent();
    }
}

