/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.Op;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.tier.sockets.Message;

public class ClearOp {
    public static void execute(ExecutablePool pool, String region, EventID eventId, Object callbackArg) {
        ClearOpImpl op = new ClearOpImpl(region, eventId, callbackArg);
        pool.execute(op);
    }

    public static void execute(Connection con, ExecutablePool pool, String region, EventID eventId, Object callbackArg) {
        ClearOpImpl op = new ClearOpImpl(region, eventId, callbackArg);
        pool.executeOn(con, (Op)op);
    }

    private ClearOp() {
    }

    private static class ClearOpImpl
    extends AbstractOp {
        public ClearOpImpl(String region, EventID eventId, Object callbackArg) {
            super(36, callbackArg != null ? 3 : 2);
            this.getMessage().addStringPart(region, true);
            this.getMessage().addBytesPart(eventId.calcBytes());
            if (callbackArg != null) {
                this.getMessage().addObjPart(callbackArg);
            }
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            this.processAck(msg, "clear region");
            return null;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 37;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startClear();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endClearSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endClear(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

