/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal.pooling;

import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Predicate;
import org.apache.geode.cache.client.internal.pooling.PooledConnection;

public class AvailableConnectionManager {
    private final Deque<PooledConnection> connections = new ConcurrentLinkedDeque<PooledConnection>();

    public PooledConnection useFirst() {
        PooledConnection connection;
        while (null != (connection = this.connections.pollFirst())) {
            if (!connection.activate()) continue;
            return connection;
        }
        return null;
    }

    public boolean remove(PooledConnection connection) {
        return this.connections.remove(connection);
    }

    public PooledConnection useFirst(Predicate<PooledConnection> predicate) {
        EqualsWithPredicate equalsWithPredicate = new EqualsWithPredicate(predicate);
        while (this.connections.removeFirstOccurrence(equalsWithPredicate)) {
            PooledConnection connection = equalsWithPredicate.getConnectionThatMatched();
            if (!connection.activate()) continue;
            if (predicate.test(connection)) {
                return connection;
            }
            this.addLast(connection, false);
        }
        return null;
    }

    public void addFirst(PooledConnection connection, boolean accessed) {
        this.passivate(connection, accessed);
        this.connections.addFirst(connection);
    }

    public void addLast(PooledConnection connection, boolean accessed) {
        this.passivate(connection, accessed);
        this.connections.addLast(connection);
    }

    private void passivate(PooledConnection connection, boolean accessed) {
        if (connection.isActive()) {
            connection.passivate(accessed);
        }
    }

    Deque<PooledConnection> getDeque() {
        return this.connections;
    }

    private static class EqualsWithPredicate {
        private final Predicate<PooledConnection> predicate;
        private PooledConnection connectionThatMatched;

        EqualsWithPredicate(Predicate<PooledConnection> predicate) {
            this.predicate = predicate;
        }

        public boolean equals(Object o) {
            if (!(o instanceof PooledConnection)) {
                return false;
            }
            PooledConnection pooledConnection = (PooledConnection)o;
            if (this.predicate.test(pooledConnection)) {
                this.connectionThatMatched = pooledConnection;
                return true;
            }
            return false;
        }

        public PooledConnection getConnectionThatMatched() {
            return this.connectionThatMatched;
        }
    }
}

