/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.partitioned.Bucket;
import org.apache.geode.internal.cache.persistence.PersistenceAdvisor;
import org.apache.geode.internal.cache.persistence.PersistentMembershipView;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class MembershipViewRequest
extends DistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    private String regionPath;
    private int processorId;
    private boolean targetReinitializing;

    public MembershipViewRequest() {
    }

    public MembershipViewRequest(String regionPath, int processorId, boolean targetReinitializing) {
        this.regionPath = regionPath;
        this.processorId = processorId;
        this.targetReinitializing = targetReinitializing;
    }

    public static PersistentMembershipView send(InternalDistributedMember recipient, DistributionManager dm, String regionPath, boolean targetReinitializing) throws ReplyException {
        MembershipViewRequestReplyProcessor processor = new MembershipViewRequestReplyProcessor(dm, recipient);
        MembershipViewRequest msg = new MembershipViewRequest(regionPath, processor.getProcessorId(), targetReinitializing);
        msg.setRecipient(recipient);
        dm.putOutgoing(msg);
        return processor.getResult();
    }

    public static Set<PersistentMembershipView> send(Set<InternalDistributedMember> recipients, DistributionManager dm, String regionPath) throws ReplyException {
        MembershipViewRequestReplyProcessor processor = new MembershipViewRequestReplyProcessor(dm, recipients);
        MembershipViewRequest msg = new MembershipViewRequest(regionPath, processor.getProcessorId(), false);
        msg.setRecipients(recipients);
        dm.putOutgoing(msg);
        return processor.getResults();
    }

    @Override
    public int getProcessorType() {
        return this.targetReinitializing ? 77 : 75;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ClusterDistributionManager dm) {
        LocalRegion.InitializationLevel initLevel = this.targetReinitializing ? LocalRegion.InitializationLevel.AFTER_INITIAL_IMAGE : LocalRegion.InitializationLevel.ANY_INIT;
        LocalRegion.InitializationLevel oldLevel = LocalRegion.setThreadInitLevelRequirement(initLevel);
        PersistentMembershipView view = null;
        ReplyException exception = null;
        try {
            Bucket proxy;
            InternalCache cache = dm.getExistingCache();
            Region region = cache.getRegion(this.regionPath);
            PersistenceAdvisor persistenceAdvisor = null;
            if (region instanceof DistributedRegion) {
                persistenceAdvisor = ((DistributedRegion)region).getPersistenceAdvisor();
            } else if (region == null && (proxy = PartitionedRegionHelper.getProxyBucketRegion(dm.getCache(), this.regionPath, false)) != null) {
                persistenceAdvisor = proxy.getPersistenceAdvisor();
            }
            if (persistenceAdvisor != null) {
                view = persistenceAdvisor.getMembershipView();
            }
        }
        catch (RegionDestroyedException e) {
            logger.debug("<RegionDestroyed> {}", (Object)this);
        }
        catch (CancelException e) {
            logger.debug("<CancelException> {}", (Object)this);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            exception = new ReplyException(t);
        }
        finally {
            LocalRegion.setThreadInitLevelRequirement(oldLevel);
            MembershipViewReplyMessage replyMsg = new MembershipViewReplyMessage();
            replyMsg.setRecipient(this.getSender());
            replyMsg.setProcessorId(this.processorId);
            replyMsg.view = view;
            if (logger.isDebugEnabled()) {
                logger.debug("MembershipViewRequest returning view {} for region {}", (Object)view, (Object)this.regionPath);
            }
            if (exception != null) {
                replyMsg.setException(exception);
            }
            dm.putOutgoing(replyMsg);
        }
    }

    public int getDSFID() {
        return 2100;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.processorId = in.readInt();
        this.regionPath = DataSerializer.readString(in);
        this.targetReinitializing = in.readBoolean();
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeInt(this.processorId);
        DataSerializer.writeString(this.regionPath, out);
        out.writeBoolean(this.targetReinitializing);
    }

    public static class MembershipViewReplyMessage
    extends ReplyMessage {
        private PersistentMembershipView view;

        @Override
        public int getDSFID() {
            return 2101;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            boolean hasView = in.readBoolean();
            if (hasView) {
                this.view = new PersistentMembershipView();
                InternalDataSerializer.invokeFromData(this.view, in);
            }
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            if (this.view == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                InternalDataSerializer.invokeToData(this.view, out);
            }
        }
    }

    private static class MembershipViewRequestReplyProcessor
    extends ReplyProcessor21 {
        private Set<PersistentMembershipView> views = new HashSet<PersistentMembershipView>();

        public MembershipViewRequestReplyProcessor(DistributionManager dm, InternalDistributedMember member) {
            super(dm, member);
        }

        public MembershipViewRequestReplyProcessor(DistributionManager dm, Set<InternalDistributedMember> members) {
            super(dm, members);
        }

        public PersistentMembershipView getResult() {
            this.waitForRepliesUninterruptibly();
            if (this.views.isEmpty()) {
                throw new ReplyException("Member departed");
            }
            return this.views.iterator().next();
        }

        public Set<PersistentMembershipView> getResults() {
            this.waitForRepliesUninterruptibly();
            return this.views;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            if (msg instanceof MembershipViewReplyMessage) {
                PersistentMembershipView view = ((MembershipViewReplyMessage)msg).view;
                if (logger.isDebugEnabled()) {
                    logger.debug("MembershipViewReplyProcessor received {}", (Object)view);
                }
                if (view != null) {
                    MembershipViewRequestReplyProcessor membershipViewRequestReplyProcessor = this;
                    synchronized (membershipViewRequestReplyProcessor) {
                        this.views.add(view);
                    }
                }
            }
            super.process(msg);
        }
    }
}

