/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.geode.DataSerializer;
import org.apache.geode.internal.cache.tier.sockets.CacheServerHelper;
import org.apache.geode.internal.cache.tier.sockets.ObjectPartList651;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class SerializedObjectPartList
extends ObjectPartList651 {
    public SerializedObjectPartList() {
    }

    public SerializedObjectPartList(int maximumchunksize, boolean hasKeys) {
        super(maximumchunksize, hasKeys);
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        out.writeBoolean(this.hasKeys);
        if (this.objectTypeArray != null) {
            int numObjects = this.objects.size();
            out.writeInt(numObjects);
            for (int index = 0; index < numObjects; ++index) {
                Object value = this.objects.get(index);
                byte objectType = this.objectTypeArray[index];
                if (this.hasKeys) {
                    context.getSerializer().writeObject(this.keys.get(index), out);
                }
                if (objectType == 3) {
                    out.writeByte(3);
                } else if (objectType == 2) {
                    out.writeByte(2);
                } else if (objectType == 0) {
                    out.writeByte(0);
                } else {
                    out.writeByte(1);
                }
                if (objectType == 2) {
                    DataSerializer.writeByteArray(CacheServerHelper.serialize(value), out);
                    DataSerializer.writeString(value.toString(), out);
                    continue;
                }
                if (value instanceof byte[]) {
                    DataSerializer.writeByteArray((byte[])value, out);
                    continue;
                }
                DataSerializer.writeObjectAsByteArray(value, out);
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        boolean keysPresent = in.readBoolean();
        if (keysPresent) {
            this.keys = new ArrayList();
        }
        this.hasKeys = keysPresent;
        int numObjects = in.readInt();
        this.objectTypeArray = new byte[numObjects];
        if (numObjects > 0) {
            for (int index = 0; index < numObjects; ++index) {
                Object value;
                byte objectType;
                if (keysPresent) {
                    Object key = context.getDeserializer().readObject(in);
                    this.keys.add(key);
                }
                this.objectTypeArray[index] = objectType = in.readByte();
                if (objectType == 2) {
                    byte[] exBytes = DataSerializer.readByteArray(in);
                    value = CacheServerHelper.deserialize(exBytes);
                    DataSerializer.readString(in);
                } else {
                    value = DataSerializer.readByteArray(in);
                }
                this.objects.add(value);
            }
        }
    }

    public boolean isBytes(int index) {
        return this.objectTypeArray[index] == 0;
    }

    public boolean isException(int index) {
        return this.objectTypeArray[index] == 2;
    }

    @Override
    public int getDSFID() {
        return 2125;
    }
}

