/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tx;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.CachedDeserializableFactory;
import org.apache.geode.internal.cache.DataLocationException;
import org.apache.geode.internal.cache.KeyInfo;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RemoteOperationException;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tx.RemoteOperationMessage;
import org.apache.geode.internal.cache.tx.RemoteOperationMessageWithDirectReply;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.offheap.OffHeapHelper;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.StaticSerialization;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.util.BlobHelper;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class RemoteGetMessage
extends RemoteOperationMessageWithDirectReply {
    private static final Logger logger = LogService.getLogger();
    private Object key;
    private Object cbArg;
    private ClientProxyMembershipID context;

    public RemoteGetMessage() {
    }

    private RemoteGetMessage(InternalDistributedMember recipient, String regionPath, DirectReplyProcessor processor, Object key, Object aCallbackArgument, ClientProxyMembershipID context) {
        super(recipient, regionPath, processor);
        this.key = key;
        this.cbArg = aCallbackArgument;
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected boolean operateOnRegion(ClusterDistributionManager dm, LocalRegion r, long startTime) throws RemoteOperationException {
        boolean bl;
        if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
            logger.trace(LogMarker.DM_VERBOSE, "RemoteGetMessage operateOnRegion: {}", (Object)r.getFullPath());
        }
        if (this.getTXUniqId() != -1) assert (r.getDataView() instanceof TXStateProxy);
        r.waitOnInitialization();
        Object val = null;
        try {
            BucketRegion.RawValue valueBytes;
            KeyInfo keyInfo = r.getKeyInfo(this.key, this.cbArg);
            val = r.getDataView().getSerializedValue(r, keyInfo, false, this.context, null, false);
            BucketRegion.RawValue rawValue = valueBytes = val instanceof BucketRegion.RawValue ? (BucketRegion.RawValue)val : new BucketRegion.RawValue(val);
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "GetMessage sending serialized value {} back via GetReplyMessage using processorId: {}", (Object)valueBytes, (Object)this.getProcessorId());
            }
            GetReplyMessage.send(this.getSender(), this.getProcessorId(), valueBytes, this.getReplySender(dm));
            bl = false;
        }
        catch (DistributedSystemDisconnectedException sde) {
            this.sendReply(this.getSender(), this.processorId, dm, new ReplyException(new RemoteOperationException("Operation got interrupted due to shutdown in progress on remote VM.", sde)), r, startTime);
            boolean bl2 = false;
            OffHeapHelper.release(val);
            return bl2;
        }
        catch (DataLocationException e) {
            this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(e), r, startTime);
            boolean bl3 = false;
            {
                catch (Throwable throwable) {
                    OffHeapHelper.release(val);
                    throw throwable;
                }
            }
            OffHeapHelper.release(val);
            return bl3;
        }
        OffHeapHelper.release(val);
        return bl;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; key=").append(this.key).append("; callback arg=").append(this.cbArg);
    }

    public int getDSFID() {
        return -24;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.key = DataSerializer.readObject(in);
        this.cbArg = DataSerializer.readObject(in);
        this.context = (ClientProxyMembershipID)DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeObject(this.key, out);
        DataSerializer.writeObject(this.cbArg, out);
        DataSerializer.writeObject(this.context, out);
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public static RemoteGetResponse send(InternalDistributedMember recipient, LocalRegion r, Object key, Object aCallbackArgument, ClientProxyMembershipID requestingClient) throws RemoteOperationException {
        Assert.assertTrue(recipient != null, "RemoteGetMessage NULL recipient");
        RemoteGetResponse p = new RemoteGetResponse(r.getSystem(), recipient);
        RemoteGetMessage m = new RemoteGetMessage(recipient, r.getFullPath(), p, key, aCallbackArgument, requestingClient);
        Set<InternalDistributedMember> failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new RemoteOperationException(String.format("Failed sending < %s >", m));
        }
        return p;
    }

    public static class RemoteGetResponse
    extends RemoteOperationMessage.RemoteOperationResponse {
        private volatile GetReplyMessage getReply;
        private volatile boolean returnValueReceived;
        private volatile long start;

        public RemoteGetResponse(InternalDistributedSystem ds, InternalDistributedMember recipient) {
            super(ds, recipient, false);
        }

        @Override
        public void process(DistributionMessage msg) {
            if (DistributionStats.enableClockStats) {
                this.start = DistributionStats.getStatTime();
            }
            if (msg instanceof GetReplyMessage) {
                GetReplyMessage reply = (GetReplyMessage)msg;
                if (reply.valueInBytes != null) {
                    this.getReply = reply;
                }
                this.returnValueReceived = true;
            }
            super.process(msg);
        }

        public Object getValue(boolean preferCD) throws RemoteOperationException {
            GetReplyMessage reply = this.getReply;
            try {
                if (reply != null) {
                    if (reply.valueIsByteArray) {
                        return reply.valueInBytes;
                    }
                    if (preferCD) {
                        return CachedDeserializableFactory.create(reply.valueInBytes, this.getDistributionManager().getCache());
                    }
                    return BlobHelper.deserializeBlob(reply.valueInBytes, reply.remoteVersion, null);
                }
                return null;
            }
            catch (IOException e) {
                throw new RemoteOperationException("Unable to deserialize value (IOException)", e);
            }
            catch (ClassNotFoundException e) {
                throw new RemoteOperationException("Unable to deserialize value (ClassNotFoundException)", e);
            }
        }

        public Object waitForResponse(boolean preferCD) throws RemoteOperationException {
            this.waitForRemoteResponse();
            if (DistributionStats.enableClockStats) {
                this.getDistributionManager().getStats().incReplyHandOffTime(this.start);
            }
            if (!this.returnValueReceived) {
                throw new RemoteOperationException("no return value received");
            }
            return this.getValue(preferCD);
        }
    }

    public static class GetReplyMessage
    extends ReplyMessage {
        private transient BucketRegion.RawValue rawVal;
        public boolean valueIsByteArray;
        public transient byte[] valueInBytes;
        public transient Version remoteVersion;

        public GetReplyMessage() {
        }

        private GetReplyMessage(int processorId, BucketRegion.RawValue val) {
            this.setProcessorId(processorId);
            this.rawVal = val;
            this.valueIsByteArray = val.isValueByteArray();
        }

        @Override
        public boolean getInlineProcess() {
            return true;
        }

        public static void send(InternalDistributedMember recipient, int processorId, BucketRegion.RawValue val, ReplySender replySender) throws RemoteOperationException {
            Assert.assertTrue(recipient != null, "PRDistribuedGetReplyMessage NULL reply message");
            GetReplyMessage m = new GetReplyMessage(processorId, val);
            m.setRecipient(recipient);
            replySender.putOutgoing(m);
        }

        @Override
        public void process(DistributionManager dm, ReplyProcessor21 processor) {
            boolean isDebugEnabled = logger.isTraceEnabled(LogMarker.DM_VERBOSE);
            long startTime = this.getTimestamp();
            if (isDebugEnabled) {
                logger.trace(LogMarker.DM_VERBOSE, "GetReplyMessage process invoking reply processor with processorId:{}", (Object)this.processorId);
            }
            if (processor == null) {
                if (isDebugEnabled) {
                    logger.trace(LogMarker.DM_VERBOSE, "GetReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (isDebugEnabled) {
                logger.trace(LogMarker.DM_VERBOSE, "{} Processed {}", (Object)processor, (Object)this);
            }
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public int getDSFID() {
            return -25;
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeByte(this.valueIsByteArray ? 1 : 0);
            this.rawVal.writeAsByteArray(out);
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.valueIsByteArray = in.readByte() == 1;
            this.valueInBytes = DataSerializer.readByteArray(in);
            if (!this.valueIsByteArray) {
                this.remoteVersion = StaticSerialization.getVersionForDataStreamOrNull((DataInput)in);
            }
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("GetReplyMessage ").append("processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender()).append(" returning serialized value=").append(this.rawVal);
            return sb.toString();
        }
    }
}

