/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.jndi;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.internal.jndi.ContextImpl;

public class InitialContextFactoryImpl
implements InitialContextFactory {
    @MakeNotStatic
    private static final Map oldSystemProps = new HashMap();
    @MakeNotStatic
    private static Context ctx;

    public synchronized Context getInitialContext(Hashtable environment) throws NamingException {
        if (ctx == null) {
            ctx = new ContextImpl();
        }
        return ctx;
    }

    public void setAsInitial() throws NamingException {
        String key = "java.naming.factory.initial";
        oldSystemProps.put(key, System.getProperty(key));
        key = "java.naming.factory.url.pkgs";
        oldSystemProps.put(key, System.getProperty(key));
        System.setProperty("java.naming.factory.initial", InitialContextFactoryImpl.class.getName());
        System.setProperty("java.naming.factory.url.pkgs", "org.apache.geode.internal.jndi");
    }

    public static void revertSetAsInitial() {
        for (Map.Entry entry : oldSystemProps.entrySet()) {
            InitialContextFactoryImpl.restoreSystemProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private static void restoreSystemProperty(String key, String value) {
        if (value != null) {
            System.setProperty(key, value);
        } else {
            System.getProperties().remove(key);
        }
    }
}

