/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.monitoring;

import java.util.Map;
import java.util.Properties;
import java.util.TimerTask;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.distributed.internal.DistributionConfigImpl;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.control.ResourceManagerStats;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.geode.internal.monitoring.executor.AbstractExecutor;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ThreadsMonitoringProcess
extends TimerTask {
    private final ThreadsMonitoring threadsMonitoring;
    private ResourceManagerStats resourceManagerStats = null;
    private static final Logger logger = LogService.getLogger();
    private final int timeLimit;
    private final InternalDistributedSystem internalDistributedSystem;
    private final Properties nonDefault = new Properties();
    private final DistributionConfigImpl distributionConfigImpl = new DistributionConfigImpl(this.nonDefault);

    protected ThreadsMonitoringProcess(ThreadsMonitoring tMonitoring, InternalDistributedSystem iDistributedSystem) {
        this.timeLimit = this.distributionConfigImpl.getThreadMonitorTimeLimit();
        this.threadsMonitoring = tMonitoring;
        this.internalDistributedSystem = iDistributedSystem;
    }

    public boolean mapValidation() {
        boolean isStuck = false;
        int numOfStuck = 0;
        for (Map.Entry<Long, AbstractExecutor> entry1 : this.threadsMonitoring.getMonitorMap().entrySet()) {
            logger.trace("Checking thread {}", (Object)entry1.getKey());
            long currentTime = System.currentTimeMillis();
            long delta = currentTime - entry1.getValue().getStartTime();
            if (delta < (long)this.timeLimit) continue;
            isStuck = true;
            ++numOfStuck;
            logger.warn("Thread {} (0x{}) is stuck", (Object)entry1.getKey(), (Object)Long.toHexString(entry1.getKey()));
            entry1.getValue().handleExpiry(delta);
        }
        if (!isStuck) {
            if (this.resourceManagerStats != null) {
                this.resourceManagerStats.setNumThreadStuck(0);
            }
            logger.trace("There are no stuck threads in the system");
            return false;
        }
        if (this.resourceManagerStats != null) {
            this.resourceManagerStats.setNumThreadStuck(numOfStuck);
        }
        if (numOfStuck != 1) {
            logger.warn("There are {} stuck threads in this node", (Object)numOfStuck);
        } else {
            logger.warn("There is 1 stuck thread in this node");
        }
        return true;
    }

    @Override
    public void run() {
        if (this.resourceManagerStats == null) {
            try {
                if (this.internalDistributedSystem == null || !this.internalDistributedSystem.isConnected()) {
                    return;
                }
                DistributionManager distributionManager = this.internalDistributedSystem.getDistributionManager();
                InternalCache cache = distributionManager.getExistingCache();
                this.resourceManagerStats = cache.getInternalResourceManager().getStats();
            }
            catch (CacheClosedException e1) {
                logger.trace("No cache exists yet - process will run on next iteration");
            }
        } else {
            this.mapValidation();
        }
    }

    public ResourceManagerStats getResourceManagerStats() {
        return this.resourceManagerStats;
    }
}

