/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.geode.internal.process.ConnectionFailedException;
import org.apache.geode.internal.process.FileProcessController;
import org.apache.geode.internal.process.MBeanInvocationFailedException;
import org.apache.geode.internal.process.MBeanProcessController;
import org.apache.geode.internal.process.ProcessController;
import org.apache.geode.internal.process.ProcessControllerParameters;
import org.apache.geode.internal.process.UnableToControlProcessException;

public class MBeanOrFileProcessController
implements ProcessController {
    private final ProcessController mbeanController;
    private final ProcessController fileController;

    public MBeanOrFileProcessController(ProcessControllerParameters parameters, int pid) {
        this.mbeanController = new MBeanProcessController(parameters, pid);
        this.fileController = new FileProcessController(parameters, pid);
    }

    @Override
    public String status() throws UnableToControlProcessException, ConnectionFailedException, IOException, MBeanInvocationFailedException, InterruptedException, TimeoutException {
        try {
            return this.mbeanController.status();
        }
        catch (IOException | ConnectionFailedException | MBeanInvocationFailedException | UnableToControlProcessException e) {
            String message = e.getMessage();
            if (message != null && message.toLowerCase().contains("no such process")) {
                throw e;
            }
            return this.fileController.status();
        }
    }

    @Override
    public void stop() throws UnableToControlProcessException, ConnectionFailedException, IOException, MBeanInvocationFailedException {
        try {
            this.mbeanController.stop();
        }
        catch (IOException | ConnectionFailedException | MBeanInvocationFailedException | UnableToControlProcessException e) {
            this.fileController.stop();
        }
    }

    @Override
    public int getProcessId() {
        return this.mbeanController.getProcessId();
    }

    @Override
    public void checkPidSupport() {
    }
}

