/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.Properties;
import org.apache.geode.CancelCriterion;
import org.apache.geode.CancelException;
import org.apache.geode.SystemFailure;
import org.apache.geode.alerting.internal.spi.AlertingAction;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.DMStats;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.LonerDistributionManager;
import org.apache.geode.distributed.internal.direct.DirectChannel;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.api.MemberShunnedException;
import org.apache.geode.distributed.internal.membership.api.Membership;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.net.BufferPool;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.net.SocketCreatorFactory;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.internal.tcp.Connection;
import org.apache.geode.internal.tcp.ConnectionException;
import org.apache.geode.internal.tcp.ConnectionTable;
import org.apache.geode.internal.tcp.PeerConnectionFactory;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class TCPConduit
implements Runnable {
    private static final Logger logger = LogService.getLogger();
    @MakeNotStatic
    private static int LISTENER_CLOSE_TIMEOUT;
    @MakeNotStatic
    private static int BACKLOG;
    private final boolean useSSL;
    private final SocketCreator socketCreator;
    private final Membership<InternalDistributedMember> membership;
    int tcpBufferSize = 32768;
    int idleConnectionTimeout = 60000;
    private int port;
    private final int[] tcpPortRange = new int[]{DistributionConfig.DEFAULT_MEMBERSHIP_PORT_RANGE[0], DistributionConfig.DEFAULT_MEMBERSHIP_PORT_RANGE[1]};
    private InternalDistributedMember localAddr;
    private final InetAddress address;
    private final boolean isBindAddress;
    private final DirectChannel directChannel;
    private DMStats stats;
    private DistributionConfig config;
    private InetSocketAddress id;
    private volatile boolean stopped;
    private Thread thread;
    private ServerSocketChannel channel;
    private ServerSocket socket;
    private ConnectionTable conTable;
    private volatile Exception shutdownCause;
    private final Stopper stopper = new Stopper();

    public TCPConduit(Membership mgr, int port, InetAddress address, boolean isBindAddress, DirectChannel receiver, Properties props) throws ConnectionException {
        this.parseProperties(props);
        this.address = address;
        this.isBindAddress = isBindAddress;
        this.port = port;
        this.directChannel = receiver;
        this.stats = null;
        this.config = null;
        this.membership = mgr;
        if (this.directChannel != null) {
            this.stats = this.directChannel.getDMStats();
            this.config = this.directChannel.getDMConfig();
        }
        if (this.getStats() == null) {
            this.stats = new LonerDistributionManager.DummyDMStats();
        }
        this.conTable = ConnectionTable.create(this);
        this.socketCreator = SocketCreatorFactory.getSocketCreatorForComponent(SecurableCommunicationChannel.CLUSTER);
        this.useSSL = this.socketCreator.useSSL();
        if (address == null) {
            try {
                LocalHostUtil.getLocalHost();
            }
            catch (UnknownHostException e) {
                throw new ConnectionException("Unable to resolve localHost address", e);
            }
        }
        this.startAcceptor();
    }

    public static void init() {
        LISTENER_CLOSE_TIMEOUT = Integer.getInteger("p2p.listenerCloseTimeout", 60000);
        BACKLOG = Integer.getInteger("p2p.backlog", 1280);
        if (Boolean.getBoolean("p2p.oldIO")) {
            logger.warn("detected use of p2p.oldIO setting - this is no longer supported");
        }
    }

    public Membership<InternalDistributedMember> getMembership() {
        return this.membership;
    }

    public static int getBackLog() {
        return BACKLOG;
    }

    private void parseProperties(Properties p) {
        if (p != null) {
            String s = p.getProperty("p2p.tcpBufferSize", String.valueOf(this.tcpBufferSize));
            try {
                this.tcpBufferSize = Integer.parseInt(s);
            }
            catch (Exception e) {
                logger.warn("exception parsing p2p.tcpBufferSize", (Throwable)e);
            }
            if (this.tcpBufferSize < Connection.SMALL_BUFFER_SIZE) {
                this.tcpBufferSize = Connection.SMALL_BUFFER_SIZE;
            }
            s = p.getProperty("p2p.idleConnectionTimeout", String.valueOf(this.idleConnectionTimeout));
            try {
                this.idleConnectionTimeout = Integer.parseInt(s);
            }
            catch (Exception e) {
                logger.warn("exception parsing p2p.idleConnectionTimeout", (Throwable)e);
            }
            s = p.getProperty("membership_port_range_start");
            try {
                this.tcpPortRange[0] = Integer.parseInt(s);
            }
            catch (Exception e) {
                logger.warn("Exception parsing membership-port-range start port.", (Throwable)e);
            }
            s = p.getProperty("membership_port_range_end");
            try {
                this.tcpPortRange[1] = Integer.parseInt(s);
            }
            catch (Exception e) {
                logger.warn("Exception parsing membership-port-range end port.", (Throwable)e);
            }
        }
    }

    private void startAcceptor() throws ConnectionException {
        int localPort;
        int p = this.port;
        this.createServerSocket();
        try {
            localPort = this.socket.getLocalPort();
            this.id = new InetSocketAddress(this.socket.getInetAddress(), localPort);
            this.stopped = false;
            this.thread = new LoggingThread("P2P Listener Thread " + this.id, (Runnable)this);
            try {
                this.thread.setPriority(10);
            }
            catch (Exception e) {
                logger.info("unable to set listener priority: {}", (Object)e.getMessage());
            }
            if (!Boolean.getBoolean("p2p.test.inhibitAcceptor")) {
                this.thread.start();
            } else {
                logger.fatal("p2p.test.inhibitAcceptor was found to be set, inhibiting incoming tcp/ip connections");
                this.socket.close();
            }
        }
        catch (IOException io) {
            String s = "While creating ServerSocket on port " + p;
            throw new ConnectionException(s, io);
        }
        this.port = localPort;
    }

    private void createServerSocket() {
        int serverPort = this.port;
        int connectionRequestBacklog = BACKLOG;
        InetAddress bindAddress = this.address;
        try {
            if (serverPort <= 0) {
                this.socket = this.socketCreator.createServerSocketUsingPortRange(bindAddress, connectionRequestBacklog, this.isBindAddress, true, 0, this.tcpPortRange);
            } else {
                ServerSocketChannel channel = ServerSocketChannel.open();
                this.socket = channel.socket();
                InetSocketAddress inetSocketAddress = new InetSocketAddress(this.isBindAddress ? bindAddress : null, serverPort);
                this.socket.bind(inetSocketAddress, connectionRequestBacklog);
            }
            try {
                this.socket.setReceiveBufferSize(this.tcpBufferSize);
                int newSize = this.socket.getReceiveBufferSize();
                if (newSize != this.tcpBufferSize) {
                    logger.info("{} is {} instead of the requested {}", (Object)"Listener receiverBufferSize", (Object)newSize, (Object)this.tcpBufferSize);
                }
            }
            catch (SocketException ex) {
                logger.warn("Failed to set listener receiverBufferSize to {}", (Object)this.tcpBufferSize);
            }
            this.channel = this.socket.getChannel();
            this.port = this.socket.getLocalPort();
        }
        catch (IOException io) {
            throw new ConnectionException(String.format("While creating ServerSocket on port %s with address %s", serverPort, bindAddress), io);
        }
    }

    public void emergencyClose() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        try {
            if (this.channel != null) {
                this.channel.close();
            } else if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ConnectionTable.emergencyClose();
        this.socket = null;
        this.thread = null;
        this.conTable = null;
    }

    public void stop(Exception cause) {
        if (!this.stopped) {
            this.stopped = true;
            this.shutdownCause = cause;
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "Shutting down conduit");
            }
            try {
                long timeout = System.currentTimeMillis() + (long)LISTENER_CLOSE_TIMEOUT;
                Thread t = this.thread;
                if (this.channel != null) {
                    this.channel.close();
                } else {
                    ServerSocket s = this.socket;
                    if (s != null) {
                        s.close();
                    }
                    if (t != null) {
                        t.interrupt();
                    }
                }
                while ((t = this.thread) != null && t.isAlive()) {
                    t.join(200L);
                    if (timeout > System.currentTimeMillis()) continue;
                }
                if (t != null && t.isAlive()) {
                    logger.warn("Unable to shut down listener within {}ms.  Unable to interrupt socket.accept() due to JDK bug. Giving up.", (Object)LISTENER_CLOSE_TIMEOUT);
                }
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
            this.conTable.close();
            this.socket = null;
            this.thread = null;
            this.conTable = null;
        }
    }

    public void restart() throws ConnectionException {
        if (!this.stopped) {
            return;
        }
        this.stats = null;
        if (this.directChannel != null) {
            this.stats = this.directChannel.getDMStats();
        }
        if (this.getStats() == null) {
            this.stats = new LonerDistributionManager.DummyDMStats();
        }
        this.conTable = ConnectionTable.create(this);
        this.startAcceptor();
    }

    @Override
    public void run() {
        ConnectionTable.threadWantsSharedResources();
        if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
            logger.trace(LogMarker.DM_VERBOSE, "Starting P2P Listener on  {}", (Object)this.id);
        }
        while (true) {
            block23: {
                SystemFailure.checkFailure();
                if (this.stopper.isCancelInProgress() || this.stopped || Thread.currentThread().isInterrupted()) break;
                Socket othersock = null;
                try {
                    SocketChannel otherChannel = this.channel.accept();
                    othersock = otherChannel.socket();
                    if (this.stopped) {
                        try {
                            if (othersock == null) continue;
                            othersock.close();
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    this.acceptConnection(othersock);
                }
                catch (ClosedByInterruptException otherChannel) {
                }
                catch (ClosedChannelException | CancelException e) {
                    break;
                }
                catch (IOException e) {
                    this.getStats().incFailedAccept();
                    try {
                        if (othersock != null) {
                            othersock.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (this.stopped) break block23;
                    if (e instanceof SocketException && "Socket closed".equalsIgnoreCase(e.getMessage())) {
                        if (this.socket.isClosed()) break block23;
                        logger.warn("ServerSocket threw 'socket closed' exception but says it is not closed", (Throwable)e);
                        try {
                            this.socket.close();
                            this.createServerSocket();
                        }
                        catch (IOException ioe) {
                            logger.fatal("Unable to close and recreate server socket", (Throwable)ioe);
                            try {
                                Thread.sleep(5000L);
                                break block23;
                            }
                            catch (InterruptedException ie) {
                                logger.info("Interrupted and exiting while trying to recreate listener sockets");
                                return;
                            }
                        }
                    }
                    if ("Too many open files".equals(e.getMessage())) {
                        this.getConTable().fileDescriptorsExhausted();
                    } else {
                        logger.warn(e.getMessage(), (Throwable)e);
                    }
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
            if (this.stopped || !this.socket.isClosed()) continue;
            logger.warn("ServerSocket closed - reopening");
            try {
                this.createServerSocket();
            }
            catch (ConnectionException ex) {
                logger.warn(ex.getMessage(), (Throwable)ex);
            }
        }
        if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
            logger.trace("Stopped P2P Listener on  {}", (Object)this.id);
        }
    }

    ConnectionTable getConTable() {
        ConnectionTable result = this.conTable;
        if (result == null) {
            this.stopper.checkCancelInProgress(null);
            throw new DistributedSystemDisconnectedException("tcp layer has been shutdown");
        }
        return result;
    }

    private void acceptConnection(Socket otherSocket) {
        block5: {
            try {
                this.getConTable().acceptConnection(otherSocket, new PeerConnectionFactory());
            }
            catch (IOException | ConnectionException io) {
                if (!this.stopped) {
                    this.getStats().incFailedAccept();
                }
            }
            catch (CancelException io) {
            }
            catch (Exception e) {
                if (this.stopped) break block5;
                this.getStats().incFailedAccept();
                logger.warn("Failed to accept connection from {} because {}", (Object)otherSocket.getInetAddress(), (Object)e);
            }
        }
    }

    public void getThreadOwnedOrderedConnectionState(DistributedMember member, Map result) {
        this.getConTable().getThreadOwnedOrderedConnectionState(member, result);
    }

    public void waitForThreadOwnedOrderedConnectionState(DistributedMember member, Map channelState) throws InterruptedException {
        this.getConTable().waitForThreadOwnedOrderedConnectionState(member, channelState);
    }

    void messageReceived(Connection receiver, DistributionMessage message, int bytesRead) throws MemberShunnedException {
        if (logger.isTraceEnabled()) {
            logger.trace("{} received {} from {}", (Object)this.id, (Object)message, (Object)receiver);
        }
        if (this.directChannel != null) {
            message.setBytesRead(bytesRead);
            message.setSender(receiver.getRemoteAddress());
            message.setSharedReceiver(receiver.isSharedResource());
            this.directChannel.receive(message, bytesRead);
        }
    }

    public InetSocketAddress getSocketId() {
        return this.id;
    }

    public int getPort() {
        return this.id.getPort();
    }

    public InternalDistributedMember getMemberId() {
        return this.localAddr;
    }

    public void setMemberId(InternalDistributedMember addr) {
        this.localAddr = addr;
    }

    public DistributionConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(InternalDistributedMember memberAddress, boolean preserveOrder, boolean retry, long startTime, long ackTimeout, long ackSATimeout) throws IOException, DistributedSystemDisconnectedException {
        if (this.stopped) {
            throw new DistributedSystemDisconnectedException("The conduit is stopped");
        }
        InternalDistributedMember memberInTrouble = null;
        Connection conn = null;
        boolean breakLoop = false;
        while (true) {
            this.stopper.checkCancelInProgress(null);
            boolean interrupted = Thread.interrupted();
            try {
                Exception problem;
                block39: {
                    if (retry || conn != null) {
                        if (!this.membership.memberExists((MemberIdentifier)memberAddress) || this.membership.isShunned((MemberIdentifier)memberAddress) || this.membership.shutdownInProgress()) {
                            throw new IOException("TCP/IP connection lost and member is not in view");
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                            this.stopper.checkCancelInProgress(e);
                        }
                        if (!this.membership.memberExists((MemberIdentifier)memberAddress) || this.membership.isShunned((MemberIdentifier)memberAddress)) {
                            throw new IOException("TCP/IP connection lost and member is not in view");
                        }
                        if (memberInTrouble == null) {
                            memberInTrouble = memberAddress;
                            logger.warn("Attempting TCP/IP reconnect to  {}", (Object)memberInTrouble);
                        } else if (logger.isDebugEnabled()) {
                            logger.debug("Attempting TCP/IP reconnect to {}", (Object)memberInTrouble);
                        }
                        this.getStats().incReconnectAttempts();
                        if (conn != null) {
                            try {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("Closing old connection.  conn={} before retrying. memberInTrouble={}", (Object)conn, (Object)memberInTrouble);
                                }
                                conn.closeForReconnect("closing before retrying");
                            }
                            catch (CancelException ex) {
                                throw ex;
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                    }
                    problem = null;
                    try {
                        boolean retryForOldConnection;
                        boolean debugRetry = false;
                        do {
                            retryForOldConnection = false;
                            conn = this.getConTable().get(memberAddress, preserveOrder, startTime, ackTimeout, ackSATimeout);
                            if (conn == null) {
                                problem = new IOException(String.format("Unable to reconnect to server; possible shutdown: %s", memberAddress));
                                continue;
                            }
                            if (!conn.isClosing() && conn.getRemoteAddress().equals(memberAddress)) continue;
                            if (logger.isDebugEnabled()) {
                                logger.debug("Got an old connection for {}: {}@{}", (Object)memberAddress, (Object)conn, (Object)conn.hashCode());
                            }
                            conn.closeOldConnection("closing old connection");
                            conn = null;
                            retryForOldConnection = true;
                            debugRetry = true;
                        } while (retryForOldConnection);
                        if (debugRetry && logger.isDebugEnabled()) {
                            logger.debug("Done removing old connections");
                        }
                    }
                    catch (ConnectionException e) {
                        problem = e;
                        breakLoop = true;
                    }
                    catch (IOException e) {
                        problem = e;
                        if (!AlertingAction.isThreadAlerting()) break block39;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Giving up connecting to alert listener {}", (Object)memberAddress);
                        }
                        breakLoop = true;
                    }
                }
                if (problem != null) {
                    if (!this.membership.memberExists((MemberIdentifier)memberAddress) || this.membership.isShunned((MemberIdentifier)memberAddress)) {
                        if (memberInTrouble != null) {
                            logger.info("Ending reconnect attempt because {} has disappeared.", memberInTrouble);
                        }
                        throw new IOException(String.format("Peer has disappeared from view: %s", memberAddress));
                    }
                    if (this.membership.shutdownInProgress()) {
                        if (memberInTrouble != null) {
                            logger.info("Ending reconnect attempt to {} because shutdown has started.", (Object)memberInTrouble);
                        }
                        this.stopper.checkCancelInProgress(null);
                        throw new DistributedSystemDisconnectedException("Abandoned because shutdown is in progress");
                    }
                    if (memberInTrouble == null) {
                        logger.warn("Error sending message to {} (will reattempt): {}", (Object)memberAddress, (Object)problem);
                        memberInTrouble = memberAddress;
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("Error sending message to {}", (Object)memberAddress, (Object)problem);
                    }
                    if (!breakLoop) continue;
                    if (!problem.getMessage().startsWith("Cannot form connection to alert listener")) {
                        logger.warn("Throwing IOException after finding breakLoop=true", (Throwable)problem);
                    }
                    if (problem instanceof IOException) {
                        throw (IOException)problem;
                    }
                    throw new IOException(String.format("Problem connecting to %s", memberAddress), problem);
                }
                if (memberInTrouble != null) {
                    logger.info("Successfully reconnected to member {}", memberInTrouble);
                    if (logger.isTraceEnabled()) {
                        logger.trace("new connection is {} memberAddress={}", (Object)conn, (Object)memberAddress);
                    }
                }
                Connection connection = conn;
                return connection;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    public String toString() {
        return String.valueOf(this.id);
    }

    public DistributionManager getDM() {
        return this.directChannel.getDM();
    }

    public void removeEndpoint(DistributedMember mbr, String reason, boolean notifyDisconnect) {
        ConnectionTable ct = this.conTable;
        if (ct == null) {
            return;
        }
        ct.removeEndpoint(mbr, reason, notifyDisconnect);
    }

    public boolean hasReceiversFor(DistributedMember endPoint) {
        ConnectionTable ct = this.conTable;
        return ct != null && ct.hasReceiversFor(endPoint);
    }

    public DMStats getStats() {
        return this.stats;
    }

    public boolean useSSL() {
        return this.useSSL;
    }

    public BufferPool getBufferPool() {
        return this.conTable.getBufferPool();
    }

    public CancelCriterion getCancelCriterion() {
        return this.stopper;
    }

    Exception getShutdownCause() {
        return this.shutdownCause;
    }

    protected SocketCreator getSocketCreator() {
        return this.socketCreator;
    }

    boolean waitForMembershipCheck(InternalDistributedMember remoteId) {
        return this.membership.waitForNewMember((MemberIdentifier)remoteId);
    }

    static {
        TCPConduit.init();
    }

    private class Stopper
    extends CancelCriterion {
        private Stopper() {
        }

        @Override
        public String cancelInProgress() {
            DistributionManager dm = TCPConduit.this.getDM();
            if (dm == null) {
                return "no distribution manager";
            }
            if (TCPConduit.this.stopped) {
                return "Conduit has been stopped";
            }
            return null;
        }

        @Override
        public RuntimeException generateCancelledException(Throwable e) {
            String reason = this.cancelInProgress();
            if (reason == null) {
                return null;
            }
            DistributionManager dm = TCPConduit.this.getDM();
            if (dm == null) {
                return new DistributedSystemDisconnectedException("no distribution manager");
            }
            RuntimeException result = dm.getCancelCriterion().generateCancelledException(e);
            if (result != null) {
                return result;
            }
            result = new DistributedSystemDisconnectedException("Conduit has been stopped", e);
            return result;
        }
    }
}

