/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util;

import java.io.DataInput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.DMStats;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.offheap.StoredObject;
import org.apache.geode.internal.serialization.ByteArrayDataInput;
import org.apache.geode.internal.serialization.DSCODE;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.pdx.internal.PdxInputStream;

public class BlobHelper {
    public static byte[] serializeToBlob(Object obj) throws IOException {
        return BlobHelper.serializeToBlob(obj, null);
    }

    public static byte[] serializeToBlob(Object obj, Version version) throws IOException {
        long start = BlobHelper.startSerialization();
        HeapDataOutputStream hdos = new HeapDataOutputStream(version);
        DataSerializer.writeObject(obj, hdos);
        byte[] result = hdos.toByteArray();
        BlobHelper.endSerialization(start, result.length);
        return result;
    }

    public static void serializeTo(Object obj, HeapDataOutputStream hdos) throws IOException {
        int startBytes = hdos.size();
        long start = BlobHelper.startSerialization();
        DataSerializer.writeObject(obj, hdos);
        BlobHelper.endSerialization(start, hdos.size() - startBytes);
    }

    public static Object deserializeBlob(byte[] blob) throws IOException, ClassNotFoundException {
        return BlobHelper.deserializeBlob(blob, null, null);
    }

    public static Object deserializeBlob(byte[] blob, Version version, ByteArrayDataInput in) throws IOException, ClassNotFoundException {
        Object result;
        long start = BlobHelper.startDeserialization();
        if (blob.length > 0 && blob[0] == DSCODE.PDX.toByte()) {
            PdxInputStream is = new PdxInputStream(blob);
            result = DataSerializer.readObject(is);
        } else {
            if (in == null) {
                in = new ByteArrayDataInput();
            }
            in.initialize(blob, version);
            result = DataSerializer.readObject((DataInput)in);
        }
        BlobHelper.endDeserialization(start, blob.length);
        return result;
    }

    public static Object deserializeOffHeapBlob(StoredObject blob) throws IOException, ClassNotFoundException {
        long start = BlobHelper.startDeserialization();
        PdxInputStream is = new PdxInputStream(blob);
        Object result = DataSerializer.readObject(is);
        BlobHelper.endDeserialization(start, blob.getDataSize());
        return result;
    }

    public static Object deserializeBuffer(ByteArrayDataInput in, int numBytes) throws IOException, ClassNotFoundException {
        long start = BlobHelper.startDeserialization();
        Object result = DataSerializer.readObject((DataInput)in);
        BlobHelper.endDeserialization(start, numBytes);
        return result;
    }

    private static long startSerialization() {
        long result = 0L;
        DMStats stats = InternalDistributedSystem.getDMStats();
        if (stats != null) {
            result = stats.startSerialization();
        }
        return result;
    }

    private static void endSerialization(long start, int bytes) {
        DMStats stats = InternalDistributedSystem.getDMStats();
        if (stats != null) {
            stats.endSerialization(start, bytes);
        }
    }

    private static long startDeserialization() {
        long result = 0L;
        DMStats stats = InternalDistributedSystem.getDMStats();
        if (stats != null) {
            result = stats.startDeserialization();
        }
        return result;
    }

    private static void endDeserialization(long start, int bytes) {
        DMStats stats = InternalDistributedSystem.getDMStats();
        if (stats != null) {
            stats.endDeserialization(start, bytes);
        }
    }
}

