/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util.concurrent;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class ReentrantSemaphore
extends Semaphore {
    private final ThreadLocal<Integer> holdCount = new ThreadLocal();

    public ReentrantSemaphore(int permits) {
        super(permits);
    }

    public ReentrantSemaphore(int permits, boolean fair) {
        super(permits, fair);
    }

    @Override
    public void acquire() throws InterruptedException {
        if (this.incHoldCount()) {
            super.acquire();
        }
    }

    @Override
    public void acquireUninterruptibly() {
        if (this.incHoldCount()) {
            super.acquireUninterruptibly();
        }
    }

    @Override
    public boolean tryAcquire() {
        if (this.incHoldCount()) {
            boolean result = super.tryAcquire();
            if (!result) {
                this.decHoldCount();
            }
            return result;
        }
        return true;
    }

    @Override
    public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.incHoldCount()) {
            boolean result = super.tryAcquire();
            if (!result) {
                this.decHoldCount();
            }
            return result;
        }
        return true;
    }

    @Override
    public void release() {
        if (this.decHoldCount()) {
            super.release();
        }
    }

    @Override
    public void acquire(int permits) throws InterruptedException {
        throw new UnsupportedOperationException("ReentrantSemaphore doesn't support a single thread using more than one permit");
    }

    @Override
    public void acquireUninterruptibly(int permits) {
        throw new UnsupportedOperationException("ReentrantSemaphore doesn't support a single thread using more than one permit");
    }

    @Override
    public boolean tryAcquire(int permits) {
        throw new UnsupportedOperationException("ReentrantSemaphore doesn't support a single thread using more than one permit");
    }

    @Override
    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("ReentrantSemaphore doesn't support a single thread using more than one permit");
    }

    @Override
    public void release(int permits) {
        throw new UnsupportedOperationException("ReentrantSemaphore doesn't support a single thread using more than one permit");
    }

    private boolean incHoldCount() {
        Integer count = this.holdCount.get();
        if (count != null) {
            this.holdCount.set(count + 1);
            return false;
        }
        this.holdCount.set(1);
        return true;
    }

    private boolean decHoldCount() {
        Integer count = this.holdCount.get();
        if (count == null) {
            return true;
        }
        if (count == 1) {
            this.holdCount.remove();
            return true;
        }
        this.holdCount.set(count - 1);
        return false;
    }

    public boolean tryAcquireMs(long timeout) throws InterruptedException {
        return this.tryAcquire(timeout, TimeUnit.MILLISECONDS);
    }

    public boolean tryAcquireMs(int permits, long timeout) throws InterruptedException {
        return this.tryAcquire(permits, TimeUnit.MILLISECONDS);
    }
}

