/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.rmi.MarshalledObject;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.management.ObjectName;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.JmxRmiSerialFilter;
import org.apache.logging.log4j.Logger;

public class JmxRmiOpenTypesSerialFilter
implements JmxRmiSerialFilter {
    private static final Logger logger = LogService.getLogger();
    @VisibleForTesting
    public static final String PROPERTY_NAME = "jmx.remote.rmi.server.serial.filter.pattern";
    private final Consumer<String> infoLogger;
    private final Supplier<Boolean> supportsSerialFilter;

    JmxRmiOpenTypesSerialFilter() {
        this(arg_0 -> ((Logger)logger).info(arg_0), () -> SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
    }

    @VisibleForTesting
    JmxRmiOpenTypesSerialFilter(Consumer<String> infoLogger, Supplier<Boolean> supportsSerialFilter) {
        this.infoLogger = infoLogger;
        this.supportsSerialFilter = supportsSerialFilter;
    }

    @Override
    public void configureSerialFilter() {
        if (this.supportsDedicatedSerialFilter()) {
            this.setPropertyValueUnlessExists(this.createSerialFilterPattern());
        }
    }

    @VisibleForTesting
    boolean supportsDedicatedSerialFilter() {
        return this.supportsSerialFilter.get();
    }

    @VisibleForTesting
    void setPropertyValueUnlessExists(String value) {
        String existingValue = System.getProperty(PROPERTY_NAME);
        if (StringUtils.isNotEmpty((CharSequence)existingValue)) {
            this.infoLogger.accept("System property jmx.remote.rmi.server.serial.filter.pattern is already configured.");
            return;
        }
        System.setProperty(PROPERTY_NAME, value);
        this.infoLogger.accept("System property jmx.remote.rmi.server.serial.filter.pattern is now configured with '" + value + "'.");
    }

    @VisibleForTesting
    String createSerialFilterPattern() {
        return Boolean.class.getName() + ';' + Byte.class.getName() + ';' + Character.class.getName() + ';' + Short.class.getName() + ';' + Integer.class.getName() + ';' + Long.class.getName() + ';' + Float.class.getName() + ';' + Double.class.getName() + ';' + String.class.getName() + ';' + BigInteger.class.getName() + ';' + BigDecimal.class.getName() + ';' + ObjectName.class.getName() + ';' + OpenType.class.getName() + ';' + CompositeData.class.getName() + ';' + TabularData.class.getName() + ';' + SimpleType.class.getName() + ';' + CompositeType.class.getName() + ';' + TabularType.class.getName() + ';' + ArrayType.class.getName() + ';' + MarshalledObject.class.getName() + ';' + "!*";
    }
}

