/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geode.CancelException;
import org.apache.geode.GemFireException;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.HasCachePerfStats;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.statistics.StatisticsClock;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.ManagementException;
import org.apache.geode.management.internal.FederationComponent;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.ManagementResourceRepo;
import org.apache.geode.management.internal.Manager;
import org.apache.geode.management.internal.MonitoringRegionCacheListener;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.logging.log4j.Logger;

public class LocalManager
extends Manager {
    private static final Logger logger = LogService.getLogger();
    private ManagementTask managementTask;
    private ScheduledExecutorService singleThreadFederationScheduler;
    private final Map<ObjectName, FederationComponent> federatedComponentMap;
    private final Object lock = new Object();
    private final SystemManagementService service;

    LocalManager(ManagementResourceRepo repo, InternalDistributedSystem system, SystemManagementService service, InternalCache cache, StatisticsFactory statisticsFactory, StatisticsClock statisticsClock) {
        super(repo, system, cache, statisticsFactory, statisticsClock);
        this.service = service;
        this.federatedComponentMap = new ConcurrentHashMap<ObjectName, FederationComponent>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLocalManagement() {
        LocalManager localManager = this;
        synchronized (localManager) {
            if (this.repo.getLocalMonitoringRegion() != null) {
                return;
            }
            this.singleThreadFederationScheduler = LoggingExecutors.newSingleThreadScheduledExecutor((String)"Management Task");
            if (logger.isDebugEnabled()) {
                logger.debug("Creating  Management Region :");
            }
            InternalRegionArguments internalArgs = new InternalRegionArguments();
            internalArgs.setIsUsedForMetaRegion(true);
            HasCachePerfStats monitoringRegionStats = new HasCachePerfStats(){

                @Override
                public CachePerfStats getCachePerfStats() {
                    return new CachePerfStats(LocalManager.this.cache.getDistributedSystem(), "RegionStats-managementRegionStats", LocalManager.this.statisticsClock);
                }

                @Override
                public boolean hasOwnStats() {
                    return true;
                }
            };
            internalArgs.setCachePerfStatsHolder(monitoringRegionStats);
            AttributesFactory<String, Object> monitorRegionAttributeFactory = new AttributesFactory<String, Object>();
            monitorRegionAttributeFactory.setScope(Scope.DISTRIBUTED_NO_ACK);
            monitorRegionAttributeFactory.setDataPolicy(DataPolicy.REPLICATE);
            monitorRegionAttributeFactory.setConcurrencyChecksEnabled(false);
            MonitoringRegionCacheListener localListener = new MonitoringRegionCacheListener(this.service);
            monitorRegionAttributeFactory.addCacheListener(localListener);
            RegionAttributes monitoringRegionAttrs = monitorRegionAttributeFactory.create();
            AttributesFactory notificationRegionAttributeFactory = new AttributesFactory();
            notificationRegionAttributeFactory.setScope(Scope.DISTRIBUTED_NO_ACK);
            notificationRegionAttributeFactory.setDataPolicy(DataPolicy.EMPTY);
            notificationRegionAttributeFactory.setConcurrencyChecksEnabled(false);
            RegionAttributes notifRegionAttrs = notificationRegionAttributeFactory.create();
            String appender = MBeanJMXAdapter.getUniqueIDForMember(this.system.getDistributedMember());
            try {
                this.repo.setLocalMonitoringRegion(this.cache.createInternalRegion("_monitoringRegion_" + appender, monitoringRegionAttrs, internalArgs));
            }
            catch (IOException | ClassNotFoundException | RegionExistsException | TimeoutException e) {
                throw new ManagementException(e);
            }
            boolean notifRegionCreated = false;
            try {
                this.repo.setLocalNotificationRegion(this.cache.createInternalRegion("_notificationRegion_" + appender, notifRegionAttrs, internalArgs));
                notifRegionCreated = true;
            }
            catch (IOException | ClassNotFoundException | RegionExistsException | TimeoutException e) {
                throw new ManagementException(e);
            }
            finally {
                if (!notifRegionCreated) {
                    this.repo.getLocalMonitoringRegion().localDestroyRegion();
                }
            }
            this.managementTask = new ManagementTask();
            this.managementTask.run();
            int updateRate = this.system.getConfig().getJmxManagerUpdateRate();
            this.singleThreadFederationScheduler.scheduleAtFixedRate(this.managementTask, updateRate, updateRate, TimeUnit.MILLISECONDS);
            if (logger.isDebugEnabled()) {
                logger.debug("Management Region created with Name : {}", (Object)this.repo.getLocalMonitoringRegion().getName());
                logger.debug("Notification Region created with Name : {}", (Object)this.repo.getLocalNotificationRegion().getName());
            }
        }
    }

    void markForFederation(ObjectName objName, FederationComponent fedComp) {
        this.federatedComponentMap.put(objName, fedComp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unMarkForFederation(ObjectName objName) {
        Object object = this.lock;
        synchronized (object) {
            if (this.federatedComponentMap.get(objName) != null) {
                this.federatedComponentMap.remove(objName);
            }
            if (this.repo.getLocalMonitoringRegion() != null && this.repo.getLocalMonitoringRegion().get(objName.toString()) != null) {
                this.repo.getLocalMonitoringRegion().remove(objName.toString());
            }
        }
    }

    private void shutdownTasks() {
        if (this.singleThreadFederationScheduler != null) {
            this.singleThreadFederationScheduler.shutdownNow();
        }
    }

    private void cleanUpResources() {
        if (!this.cache.isClosed() && InternalDistributedSystem.getConnectedInstance() != null) {
            if (this.repo.getLocalMonitoringRegion() != null) {
                for (String name : this.repo.getLocalMonitoringRegion().keySet()) {
                    ObjectName objName = null;
                    try {
                        objName = ObjectName.getInstance(name);
                        this.unMarkForFederation(objName);
                    }
                    catch (NullPointerException | MalformedObjectNameException e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Unable to clean MBean: {} due to {}", (Object)objName, (Object)e.getMessage(), (Object)e);
                    }
                }
                this.repo.destroyLocalMonitoringRegion();
            }
            if (this.repo.getLocalNotificationRegion() != null) {
                this.repo.destroyLocalNotifRegion();
            }
        }
    }

    @VisibleForTesting
    public ScheduledExecutorService getFederationScheduler() {
        return this.singleThreadFederationScheduler;
    }

    @VisibleForTesting
    public void runManagementTaskAdhoc() {
        this.managementTask.run();
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void startManager() {
        this.startLocalManagement();
        this.running = true;
    }

    @Override
    public void stopManager() {
        this.shutdownTasks();
        this.cleanUpResources();
        this.running = false;
    }

    public Map<ObjectName, FederationComponent> getFedComponents() {
        return this.federatedComponentMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doManagementTask(Map<String, FederationComponent> replicaMap) {
        if (logger.isTraceEnabled()) {
            logger.trace("Federation started at managed node : ");
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                replicaMap.clear();
                Set<ObjectName> keySet = this.federatedComponentMap.keySet();
                if (keySet.isEmpty()) {
                    return;
                }
                for (ObjectName objectName : keySet) {
                    FederationComponent fedCompInstance = this.federatedComponentMap.get(objectName);
                    if (Thread.interrupted()) {
                        replicaMap.clear();
                        return;
                    }
                    if (fedCompInstance == null) continue;
                    boolean stateChanged = fedCompInstance.refreshObjectState(this.service.isManager());
                    if (this.stopCacheOps) continue;
                    String key = objectName.toString();
                    if (!stateChanged && this.repo.keyExistsInLocalMonitoringRegion(key)) continue;
                    replicaMap.put(key, fedCompInstance);
                }
                if (this.stopCacheOps) {
                    return;
                }
                if (Thread.interrupted()) {
                    replicaMap.clear();
                    return;
                }
                this.repo.putAllInLocalMonitoringRegion(replicaMap);
            }
        }
        catch (CancelException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("Management Task Cancelled");
            }
            return;
        }
        catch (GemFireException ex) {
            if (!this.cache.isClosed() && logger.isDebugEnabled()) {
                logger.debug(ex.getMessage(), (Throwable)ex);
            }
            return;
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            throw th;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Federation completed at managed node : ");
        }
    }

    private class ManagementTask
    implements Runnable {
        private final Map<String, FederationComponent> replicaMap = new HashMap<String, FederationComponent>();

        private ManagementTask() {
        }

        @Override
        public void run() {
            LocalManager.this.doManagementTask(this.replicaMap);
        }
    }
}

