/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans.stats;

import java.util.HashMap;
import java.util.Map;
import org.apache.geode.management.internal.FederationComponent;
import org.apache.geode.management.internal.beans.stats.StatsAggregator;

public class GatewaySenderClusterStatsMonitor {
    private static final String AVERAGE_DISTRIBUTION_TIME_PER_BATCH = "AverageDistributionTimePerBatch";
    private static final String BATCHES_DISPATCHED_RATE = "BatchesDispatchedRate";
    private static final String EVENT_QUEUE_SIZE = "EventQueueSize";
    private static final String EVENTS_QUEUED_RATE = "EventsQueuedRate";
    private static final String TOTAL_BATCHES_REDISTRIBUTED = "TotalBatchesRedistributed";
    private static final String TOTAL_EVENTS_CONFLATED = "TotalEventsConflated";
    private StatsAggregator aggregator;
    private Map<String, Class<?>> typeMap = new HashMap();

    public void aggregate(FederationComponent newState, FederationComponent oldState) {
        this.aggregator.aggregate(newState, oldState);
    }

    public GatewaySenderClusterStatsMonitor() {
        this.intTypeMap();
        this.aggregator = new StatsAggregator(this.typeMap);
    }

    private void intTypeMap() {
        this.typeMap.put(AVERAGE_DISTRIBUTION_TIME_PER_BATCH, Long.TYPE);
        this.typeMap.put(BATCHES_DISPATCHED_RATE, Float.TYPE);
        this.typeMap.put(EVENT_QUEUE_SIZE, Integer.TYPE);
        this.typeMap.put(EVENTS_QUEUED_RATE, Float.TYPE);
        this.typeMap.put(TOTAL_BATCHES_REDISTRIBUTED, Integer.TYPE);
        this.typeMap.put(TOTAL_EVENTS_CONFLATED, Integer.TYPE);
    }

    public long getGatewaySenderAverageDistributionTimePerBatch() {
        return this.aggregator.getLongValue(AVERAGE_DISTRIBUTION_TIME_PER_BATCH);
    }

    public float getGatewaySenderBatchesDispatchedRate() {
        return this.aggregator.getFloatValue(BATCHES_DISPATCHED_RATE).floatValue();
    }

    public int getGatewaySenderEventQueueSize() {
        return this.aggregator.getIntValue(EVENT_QUEUE_SIZE);
    }

    public float getGatewaySenderEventsQueuedRate() {
        return this.aggregator.getFloatValue(EVENTS_QUEUED_RATE).floatValue();
    }

    public int getGatewaySenderTotalBatchesRedistributed() {
        return this.aggregator.getIntValue(TOTAL_BATCHES_REDISTRIBUTED);
    }

    public int getGatewaySenderTotalEventsConflated() {
        return this.aggregator.getIntValue(TOTAL_EVENTS_CONFLATED);
    }
}

