/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Date;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.MethodNotSupportedException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.search.SearchTerm;

public abstract class Message
implements Part {
    protected int msgnum;
    protected boolean expunged;
    protected Folder folder;
    protected Session session;

    protected Message() {
    }

    protected Message(Folder folder, int msgnum) {
        this.folder = folder;
        this.msgnum = msgnum;
        this.session = folder.getStore().getSession();
    }

    protected Message(Session session) {
        this.session = session;
    }

    public abstract Address[] getFrom() throws MessagingException;

    public abstract void setFrom() throws MessagingException;

    public abstract void setFrom(Address var1) throws MessagingException;

    public abstract void addFrom(Address[] var1) throws MessagingException;

    public abstract Address[] getRecipients(RecipientType var1) throws MessagingException;

    public Address[] getAllRecipients() throws MessagingException {
        int i;
        Address[] to = this.getRecipients(RecipientType.TO);
        Address[] cc = this.getRecipients(RecipientType.CC);
        Address[] bcc = this.getRecipients(RecipientType.BCC);
        if (to == null && cc == null && bcc == null) {
            return null;
        }
        int length = (to != null ? to.length : 0) + (cc != null ? cc.length : 0) + (bcc != null ? bcc.length : 0);
        Address[] result = new Address[length];
        int j = 0;
        if (to != null) {
            for (i = 0; i < to.length; ++i) {
                result[j++] = to[i];
            }
        }
        if (cc != null) {
            for (i = 0; i < cc.length; ++i) {
                result[j++] = cc[i];
            }
        }
        if (bcc != null) {
            for (i = 0; i < bcc.length; ++i) {
                result[j++] = bcc[i];
            }
        }
        return result;
    }

    public abstract void setRecipients(RecipientType var1, Address[] var2) throws MessagingException;

    public void setRecipient(RecipientType type, Address address) throws MessagingException {
        this.setRecipients(type, new Address[]{address});
    }

    public abstract void addRecipients(RecipientType var1, Address[] var2) throws MessagingException;

    public void addRecipient(RecipientType type, Address address) throws MessagingException {
        this.addRecipients(type, new Address[]{address});
    }

    public Address[] getReplyTo() throws MessagingException {
        return this.getFrom();
    }

    public void setReplyTo(Address[] addresses) throws MessagingException {
        throw new MethodNotSupportedException("setReplyTo not supported");
    }

    public abstract String getSubject() throws MessagingException;

    public abstract void setSubject(String var1) throws MessagingException;

    public abstract Date getSentDate() throws MessagingException;

    public abstract void setSentDate(Date var1) throws MessagingException;

    public Session getSession() {
        return this.session;
    }

    public abstract Date getReceivedDate() throws MessagingException;

    public abstract Flags getFlags() throws MessagingException;

    public boolean isSet(Flags.Flag flag) throws MessagingException {
        return this.getFlags().contains(flag);
    }

    public abstract void setFlags(Flags var1, boolean var2) throws MessagingException;

    public void setFlag(Flags.Flag flag, boolean set) throws MessagingException {
        this.setFlags(new Flags(flag), set);
    }

    public int getMessageNumber() {
        return this.msgnum;
    }

    protected void setMessageNumber(int number) {
        this.msgnum = number;
    }

    public Folder getFolder() {
        return this.folder;
    }

    public boolean isExpunged() {
        return this.expunged;
    }

    protected void setExpunged(boolean expunged) {
        this.expunged = expunged;
    }

    public abstract Message reply(boolean var1) throws MessagingException;

    public abstract void saveChanges() throws MessagingException;

    public boolean match(SearchTerm term) throws MessagingException {
        return term.match(this);
    }

    public static class RecipientType
    implements Serializable {
        public static final RecipientType TO = new RecipientType("To");
        public static final RecipientType CC = new RecipientType("Cc");
        public static final RecipientType BCC = new RecipientType("Bcc");
        protected String type;

        protected RecipientType(String type) {
            this.type = type;
        }

        protected Object readResolve() throws ObjectStreamException {
            if (this.type.equals("To")) {
                return TO;
            }
            if (this.type.equals("Cc")) {
                return CC;
            }
            if (this.type.equals("Bcc")) {
                return BCC;
            }
            throw new InvalidObjectException("Invalid RecipientType: " + this.type);
        }

        public String toString() {
            return this.type;
        }
    }
}

