/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.DelegatingBeanDefinition;
import io.micronaut.inject.qualifiers.QualifierUtils;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Internal
final class AnnotationMetadataQualifier<T>
implements Qualifier<T> {
    @NonNull
    final String annotationName;
    @NonNull
    final String annotationSimpleName;
    @Nullable
    final AnnotationValue<Annotation> qualifierAnn;

    private AnnotationMetadataQualifier(@NonNull String annotationName, @NonNull String annotationSimpleName, @Nullable AnnotationValue<Annotation> value) {
        this.annotationName = annotationName;
        this.annotationSimpleName = annotationSimpleName;
        this.qualifierAnn = value;
    }

    static <T> AnnotationMetadataQualifier<T> fromType(@NonNull AnnotationMetadata annotationMetadata, @NonNull Class<? extends Annotation> annotationType) {
        return new AnnotationMetadataQualifier<T>(annotationType.getName(), annotationType.getSimpleName(), AnnotationMetadataQualifier.resolveBindingAnnotationValue(annotationMetadata, annotationType.getName()));
    }

    static <T> AnnotationMetadataQualifier<T> fromTypeName(@NonNull AnnotationMetadata annotationMetadata, @NonNull String annotationTypeName) {
        return new AnnotationMetadataQualifier<T>(annotationTypeName, NameUtils.getSimpleName(annotationTypeName), AnnotationMetadataQualifier.resolveBindingAnnotationValue(annotationMetadata, annotationTypeName));
    }

    static <T extends Annotation> AnnotationMetadataQualifier<T> fromValue(@NonNull AnnotationMetadata annotationMetadata, @NonNull AnnotationValue<T> annotationValue) {
        return new AnnotationMetadataQualifier<T>(annotationValue.getAnnotationName(), NameUtils.getSimpleName(annotationValue.getAnnotationName()), AnnotationMetadataQualifier.resolveBindingAnnotationValue(annotationMetadata, annotationValue.getAnnotationName(), annotationValue.getValues()));
    }

    @Override
    public <BT extends BeanType<T>> Stream<BT> reduce(Class<T> beanType, Stream<BT> candidates) {
        return candidates.filter(candidate -> {
            if (!QualifierUtils.matchType(beanType, candidate)) {
                return false;
            }
            if (QualifierUtils.matchAny(beanType, candidate)) {
                return true;
            }
            if (candidate instanceof BeanDefinition) {
                BeanDefinition bdCandidate = (BeanDefinition)candidate;
                Qualifier candidateDeclaredQualifier = bdCandidate.getDeclaredQualifier();
                if (candidateDeclaredQualifier != null && candidateDeclaredQualifier.contains(this)) {
                    return true;
                }
                if (candidate instanceof DelegatingBeanDefinition && this.matchByAnnotationMetadata(candidate)) {
                    return true;
                }
            } else if (this.matchByAnnotationMetadata(candidate)) {
                return true;
            }
            return QualifierUtils.matchByCandidateName(candidate, beanType, this.annotationSimpleName);
        });
    }

    private <BT extends BeanType<T>> boolean matchByAnnotationMetadata(BT candidate) {
        if (this.qualifierAnn == null) {
            return candidate.getAnnotationMetadata().hasAnnotation(this.annotationName);
        }
        return this.qualifierAnn.equals(this.resolveBindingAnnotationValue(candidate.getAnnotationMetadata()));
    }

    @Nullable
    private <K extends Annotation> AnnotationValue<K> resolveBindingAnnotationValue(AnnotationMetadata annotationMetadata) {
        return AnnotationMetadataQualifier.resolveBindingAnnotationValue(annotationMetadata, this.annotationName, annotationMetadata.getValues(this.annotationName));
    }

    @Nullable
    private static <K extends Annotation> AnnotationValue<K> resolveBindingAnnotationValue(AnnotationMetadata annotationMetadata, String annotationName) {
        return AnnotationMetadataQualifier.resolveBindingAnnotationValue(annotationMetadata, annotationName, annotationMetadata.getValues(annotationName));
    }

    @Nullable
    private static <K extends Annotation> AnnotationValue<K> resolveBindingAnnotationValue(AnnotationMetadata annotationMetadata, String annotationName, Map<CharSequence, Object> values) {
        Map<CharSequence, Object> bindingValues = AnnotationMetadataQualifier.resolveBindingValues(annotationMetadata, values);
        if (CollectionUtils.isNotEmpty(bindingValues)) {
            return new AnnotationValue(annotationName, bindingValues);
        }
        return null;
    }

    @Nullable
    private static Map<CharSequence, Object> resolveBindingValues(AnnotationMetadata annotationMetadata, Map<CharSequence, Object> values) {
        Set<String> nonBinding = AnnotationMetadataQualifier.resolveNonBindingMembers(annotationMetadata);
        if (values.isEmpty() || nonBinding.isEmpty()) {
            return values;
        }
        HashMap<CharSequence, Object> map = new HashMap<CharSequence, Object>();
        for (Map.Entry<CharSequence, Object> entry : values.entrySet()) {
            if (nonBinding.contains(entry.getKey().toString()) || map.put(entry.getKey(), entry.getValue()) == null) continue;
            throw new IllegalStateException("Duplicate key: " + entry.getKey());
        }
        return map;
    }

    @NonNull
    private static Set<String> resolveNonBindingMembers(AnnotationMetadata annotationMetadata) {
        Object[] nonBindingArray = annotationMetadata.stringValues("javax.inject.Qualifier", "nonBinding");
        return ArrayUtils.isNotEmpty(nonBindingArray) ? new HashSet<Object>(Arrays.asList(nonBindingArray)) : Collections.emptySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        return QualifierUtils.annotationQualifiersEquals(this, o);
    }

    public int hashCode() {
        return Objects.hash(this.annotationName, this.qualifierAnn);
    }

    public String toString() {
        if (this.qualifierAnn != null) {
            return "@" + this.annotationSimpleName + "(" + this.qualifierAnn.getValues().entrySet().stream().map(entry -> entry.getKey() + "=" + this.valueToString((Map.Entry<CharSequence, Object>)entry)).collect(Collectors.joining(", ")) + ")";
        }
        return "@" + this.annotationSimpleName;
    }

    private Object valueToString(Map.Entry<CharSequence, Object> entry) {
        Object v = entry.getValue();
        if (v instanceof Object[]) {
            return Arrays.toString((Object[])v);
        }
        return v;
    }
}

