/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractPooledDerivedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledSlicedByteBuf;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.ObjectPool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

final class PooledDuplicatedByteBuf
extends AbstractPooledDerivedByteBuf {
    private static final ObjectPool<PooledDuplicatedByteBuf> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<PooledDuplicatedByteBuf>(){

        @Override
        public PooledDuplicatedByteBuf newObject(ObjectPool.Handle<PooledDuplicatedByteBuf> handle2) {
            return new PooledDuplicatedByteBuf(handle2);
        }
    });

    static PooledDuplicatedByteBuf newInstance(AbstractByteBuf unwrapped, ByteBuf wrapped, int readerIndex, int writerIndex) {
        PooledDuplicatedByteBuf duplicate = RECYCLER.get();
        duplicate.init(unwrapped, wrapped, readerIndex, writerIndex, unwrapped.maxCapacity());
        duplicate.markReaderIndex();
        duplicate.markWriterIndex();
        return duplicate;
    }

    private PooledDuplicatedByteBuf(ObjectPool.Handle<PooledDuplicatedByteBuf> handle2) {
        super(handle2);
    }

    @Override
    public int capacity() {
        return this.unwrap().capacity();
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        this.unwrap().capacity(newCapacity);
        return this;
    }

    @Override
    public int arrayOffset() {
        return this.unwrap().arrayOffset();
    }

    @Override
    public long memoryAddress() {
        return this.unwrap().memoryAddress();
    }

    @Override
    public ByteBuffer nioBuffer(int index2, int length) {
        return this.unwrap().nioBuffer(index2, length);
    }

    @Override
    public ByteBuffer[] nioBuffers(int index2, int length) {
        return this.unwrap().nioBuffers(index2, length);
    }

    @Override
    public ByteBuf copy(int index2, int length) {
        return this.unwrap().copy(index2, length);
    }

    @Override
    public ByteBuf retainedSlice(int index2, int length) {
        return PooledSlicedByteBuf.newInstance(this.unwrap(), this, index2, length);
    }

    @Override
    public ByteBuf duplicate() {
        return this.duplicate0().setIndex(this.readerIndex(), this.writerIndex());
    }

    @Override
    public ByteBuf retainedDuplicate() {
        return PooledDuplicatedByteBuf.newInstance(this.unwrap(), this, this.readerIndex(), this.writerIndex());
    }

    @Override
    public byte getByte(int index2) {
        return this.unwrap().getByte(index2);
    }

    @Override
    protected byte _getByte(int index2) {
        return this.unwrap()._getByte(index2);
    }

    @Override
    public short getShort(int index2) {
        return this.unwrap().getShort(index2);
    }

    @Override
    protected short _getShort(int index2) {
        return this.unwrap()._getShort(index2);
    }

    @Override
    public short getShortLE(int index2) {
        return this.unwrap().getShortLE(index2);
    }

    @Override
    protected short _getShortLE(int index2) {
        return this.unwrap()._getShortLE(index2);
    }

    @Override
    public int getUnsignedMedium(int index2) {
        return this.unwrap().getUnsignedMedium(index2);
    }

    @Override
    protected int _getUnsignedMedium(int index2) {
        return this.unwrap()._getUnsignedMedium(index2);
    }

    @Override
    public int getUnsignedMediumLE(int index2) {
        return this.unwrap().getUnsignedMediumLE(index2);
    }

    @Override
    protected int _getUnsignedMediumLE(int index2) {
        return this.unwrap()._getUnsignedMediumLE(index2);
    }

    @Override
    public int getInt(int index2) {
        return this.unwrap().getInt(index2);
    }

    @Override
    protected int _getInt(int index2) {
        return this.unwrap()._getInt(index2);
    }

    @Override
    public int getIntLE(int index2) {
        return this.unwrap().getIntLE(index2);
    }

    @Override
    protected int _getIntLE(int index2) {
        return this.unwrap()._getIntLE(index2);
    }

    @Override
    public long getLong(int index2) {
        return this.unwrap().getLong(index2);
    }

    @Override
    protected long _getLong(int index2) {
        return this.unwrap()._getLong(index2);
    }

    @Override
    public long getLongLE(int index2) {
        return this.unwrap().getLongLE(index2);
    }

    @Override
    protected long _getLongLE(int index2) {
        return this.unwrap()._getLongLE(index2);
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuf dst, int dstIndex, int length) {
        this.unwrap().getBytes(index2, dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, byte[] dst, int dstIndex, int length) {
        this.unwrap().getBytes(index2, dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuffer dst) {
        this.unwrap().getBytes(index2, dst);
        return this;
    }

    @Override
    public ByteBuf setByte(int index2, int value) {
        this.unwrap().setByte(index2, value);
        return this;
    }

    @Override
    protected void _setByte(int index2, int value) {
        this.unwrap()._setByte(index2, value);
    }

    @Override
    public ByteBuf setShort(int index2, int value) {
        this.unwrap().setShort(index2, value);
        return this;
    }

    @Override
    protected void _setShort(int index2, int value) {
        this.unwrap()._setShort(index2, value);
    }

    @Override
    public ByteBuf setShortLE(int index2, int value) {
        this.unwrap().setShortLE(index2, value);
        return this;
    }

    @Override
    protected void _setShortLE(int index2, int value) {
        this.unwrap()._setShortLE(index2, value);
    }

    @Override
    public ByteBuf setMedium(int index2, int value) {
        this.unwrap().setMedium(index2, value);
        return this;
    }

    @Override
    protected void _setMedium(int index2, int value) {
        this.unwrap()._setMedium(index2, value);
    }

    @Override
    public ByteBuf setMediumLE(int index2, int value) {
        this.unwrap().setMediumLE(index2, value);
        return this;
    }

    @Override
    protected void _setMediumLE(int index2, int value) {
        this.unwrap()._setMediumLE(index2, value);
    }

    @Override
    public ByteBuf setInt(int index2, int value) {
        this.unwrap().setInt(index2, value);
        return this;
    }

    @Override
    protected void _setInt(int index2, int value) {
        this.unwrap()._setInt(index2, value);
    }

    @Override
    public ByteBuf setIntLE(int index2, int value) {
        this.unwrap().setIntLE(index2, value);
        return this;
    }

    @Override
    protected void _setIntLE(int index2, int value) {
        this.unwrap()._setIntLE(index2, value);
    }

    @Override
    public ByteBuf setLong(int index2, long value) {
        this.unwrap().setLong(index2, value);
        return this;
    }

    @Override
    protected void _setLong(int index2, long value) {
        this.unwrap()._setLong(index2, value);
    }

    @Override
    public ByteBuf setLongLE(int index2, long value) {
        this.unwrap().setLongLE(index2, value);
        return this;
    }

    @Override
    protected void _setLongLE(int index2, long value) {
        this.unwrap().setLongLE(index2, value);
    }

    @Override
    public ByteBuf setBytes(int index2, byte[] src, int srcIndex, int length) {
        this.unwrap().setBytes(index2, src, srcIndex, length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuf src, int srcIndex, int length) {
        this.unwrap().setBytes(index2, src, srcIndex, length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuffer src) {
        this.unwrap().setBytes(index2, src);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, OutputStream out, int length) throws IOException {
        this.unwrap().getBytes(index2, out, length);
        return this;
    }

    @Override
    public int getBytes(int index2, GatheringByteChannel out, int length) throws IOException {
        return this.unwrap().getBytes(index2, out, length);
    }

    @Override
    public int getBytes(int index2, FileChannel out, long position, int length) throws IOException {
        return this.unwrap().getBytes(index2, out, position, length);
    }

    @Override
    public int setBytes(int index2, InputStream in, int length) throws IOException {
        return this.unwrap().setBytes(index2, in, length);
    }

    @Override
    public int setBytes(int index2, ScatteringByteChannel in, int length) throws IOException {
        return this.unwrap().setBytes(index2, in, length);
    }

    @Override
    public int setBytes(int index2, FileChannel in, long position, int length) throws IOException {
        return this.unwrap().setBytes(index2, in, position, length);
    }

    @Override
    public int forEachByte(int index2, int length, ByteProcessor processor) {
        return this.unwrap().forEachByte(index2, length, processor);
    }

    @Override
    public int forEachByteDesc(int index2, int length, ByteProcessor processor) {
        return this.unwrap().forEachByteDesc(index2, length, processor);
    }
}

