/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.internal.storage.dfs.BlockBasedFile;
import org.eclipse.jgit.internal.storage.dfs.DfsBlock;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsStreamKey;
import org.eclipse.jgit.internal.storage.pack.PackExt;

public interface DfsBlockCacheTable {
    public boolean hasBlock0(DfsStreamKey var1);

    public DfsBlock getOrLoad(BlockBasedFile var1, long var2, DfsReader var4, DfsBlockCache.ReadableChannelSupplier var5) throws IOException;

    public <T> DfsBlockCache.Ref<T> getOrLoadRef(DfsStreamKey var1, long var2, DfsBlockCache.RefLoader<T> var4) throws IOException;

    public void put(DfsBlock var1);

    public <T> DfsBlockCache.Ref<T> put(DfsStreamKey var1, long var2, long var4, T var6);

    public <T> DfsBlockCache.Ref<T> putRef(DfsStreamKey var1, long var2, T var4);

    public boolean contains(DfsStreamKey var1, long var2);

    public <T> T get(DfsStreamKey var1, long var2);

    public DfsBlockCacheStats getDfsBlockCacheStats();

    public static class DfsBlockCacheStats {
        private final AtomicReference<AtomicLong[]> statHit = new AtomicReference<AtomicLong[]>(DfsBlockCacheStats.newCounters());
        private final AtomicReference<AtomicLong[]> statMiss = new AtomicReference<AtomicLong[]>(DfsBlockCacheStats.newCounters());
        private final AtomicReference<AtomicLong[]> statEvict = new AtomicReference<AtomicLong[]>(DfsBlockCacheStats.newCounters());
        private final AtomicReference<AtomicLong[]> liveBytes = new AtomicReference<AtomicLong[]>(DfsBlockCacheStats.newCounters());

        DfsBlockCacheStats() {
        }

        void incrementHit(DfsStreamKey key) {
            DfsBlockCacheStats.getStat(this.statHit, key).incrementAndGet();
        }

        void incrementMiss(DfsStreamKey key) {
            DfsBlockCacheStats.getStat(this.statMiss, key).incrementAndGet();
        }

        void incrementEvict(DfsStreamKey key) {
            DfsBlockCacheStats.getStat(this.statEvict, key).incrementAndGet();
        }

        void addToLiveBytes(DfsStreamKey key, long size) {
            DfsBlockCacheStats.getStat(this.liveBytes, key).addAndGet(size);
        }

        long[] getCurrentSize() {
            return DfsBlockCacheStats.getStatVals(this.liveBytes);
        }

        long[] getHitCount() {
            return DfsBlockCacheStats.getStatVals(this.statHit);
        }

        long[] getMissCount() {
            return DfsBlockCacheStats.getStatVals(this.statMiss);
        }

        long[] getTotalRequestCount() {
            AtomicLong[] hit = this.statHit.get();
            AtomicLong[] miss = this.statMiss.get();
            long[] cnt = new long[Math.max(hit.length, miss.length)];
            int i2 = 0;
            while (i2 < hit.length) {
                int n = i2;
                cnt[n] = cnt[n] + hit[i2].get();
                ++i2;
            }
            i2 = 0;
            while (i2 < miss.length) {
                int n = i2;
                cnt[n] = cnt[n] + miss[i2].get();
                ++i2;
            }
            return cnt;
        }

        long[] getHitRatio() {
            AtomicLong[] hit = this.statHit.get();
            AtomicLong[] miss = this.statMiss.get();
            long[] ratio = new long[Math.max(hit.length, miss.length)];
            int i2 = 0;
            while (i2 < ratio.length) {
                long missVal;
                long hitVal;
                long total;
                ratio[i2] = i2 >= hit.length ? 0L : (i2 >= miss.length ? 100L : ((total = (hitVal = hit[i2].get()) + (missVal = miss[i2].get())) == 0L ? 0L : hitVal * 100L / total));
                ++i2;
            }
            return ratio;
        }

        long[] getEvictions() {
            return DfsBlockCacheStats.getStatVals(this.statEvict);
        }

        private static AtomicLong[] newCounters() {
            AtomicLong[] ret = new AtomicLong[PackExt.values().length];
            int i2 = 0;
            while (i2 < ret.length) {
                ret[i2] = new AtomicLong();
                ++i2;
            }
            return ret;
        }

        private static long[] getStatVals(AtomicReference<AtomicLong[]> stat) {
            AtomicLong[] stats = stat.get();
            long[] cnt = new long[stats.length];
            int i2 = 0;
            while (i2 < stats.length) {
                cnt[i2] = stats[i2].get();
                ++i2;
            }
            return cnt;
        }

        private static AtomicLong getStat(AtomicReference<AtomicLong[]> stats, DfsStreamKey key) {
            AtomicLong[] vals;
            AtomicLong[] expect;
            int pos = key.packExtPos;
            do {
                if (pos < (vals = stats.get()).length) {
                    return vals[pos];
                }
                expect = vals;
                vals = new AtomicLong[Math.max(pos + 1, PackExt.values().length)];
                System.arraycopy(expect, 0, vals, 0, expect.length);
                int i2 = expect.length;
                while (i2 < vals.length) {
                    vals[i2] = new AtomicLong();
                    ++i2;
                }
            } while (!stats.compareAndSet(expect, vals));
            return vals[pos];
        }
    }
}

