/*
 * Decompiled with CFR 0.152.
 */
package org.grails.cli.command.install;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import joptsimple.OptionSet;
import org.grails.cli.command.install.DependencyResolver;
import org.grails.cli.command.install.GroovyGrabDependencyResolver;
import org.grails.cli.command.options.CompilerOptionHandler;
import org.grails.cli.command.options.OptionSetGroovyCompilerConfiguration;
import org.grails.cli.compiler.GroovyCompilerConfiguration;
import org.grails.cli.compiler.RepositoryConfigurationFactory;
import org.grails.cli.compiler.grape.RepositoryConfiguration;
import org.springframework.boot.cli.util.Log;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.SystemPropertyUtils;

class Installer {
    private final DependencyResolver dependencyResolver;
    private final Properties installCounts;

    Installer(OptionSet options, CompilerOptionHandler compilerOptionHandler) throws IOException {
        this(new GroovyGrabDependencyResolver(Installer.createCompilerConfiguration(options, compilerOptionHandler)));
    }

    Installer(DependencyResolver resolver) throws IOException {
        this.dependencyResolver = resolver;
        this.installCounts = this.loadInstallCounts();
    }

    private static GroovyCompilerConfiguration createCompilerConfiguration(OptionSet options, CompilerOptionHandler compilerOptionHandler) {
        List<RepositoryConfiguration> repositoryConfiguration = RepositoryConfigurationFactory.createDefaultRepositoryConfiguration();
        return new OptionSetGroovyCompilerConfiguration(options, compilerOptionHandler, (List)repositoryConfiguration){

            @Override
            public boolean isAutoconfigure() {
                return false;
            }
        };
    }

    private Properties loadInstallCounts() throws IOException {
        Properties properties = new Properties();
        File installed = this.getInstalled();
        if (installed.exists()) {
            FileReader reader = new FileReader(installed);
            properties.load(reader);
            reader.close();
        }
        return properties;
    }

    private void saveInstallCounts() throws IOException {
        try (FileWriter writer = new FileWriter(this.getInstalled());){
            this.installCounts.store(writer, null);
        }
    }

    void install(List<String> artifactIdentifiers) throws Exception {
        File extDirectory = this.getDefaultExtDirectory();
        extDirectory.mkdirs();
        Log.info("Installing into: " + String.valueOf(extDirectory));
        List<File> artifactFiles = this.dependencyResolver.resolve(artifactIdentifiers);
        for (File artifactFile : artifactFiles) {
            int installCount = this.getInstallCount(artifactFile);
            if (installCount == 0) {
                FileCopyUtils.copy(artifactFile, new File(extDirectory, artifactFile.getName()));
            }
            this.setInstallCount(artifactFile, installCount + 1);
        }
        this.saveInstallCounts();
    }

    private int getInstallCount(File file) {
        String countString = this.installCounts.getProperty(file.getName());
        if (countString == null) {
            return 0;
        }
        return Integer.parseInt(countString);
    }

    private void setInstallCount(File file, int count) {
        if (count == 0) {
            this.installCounts.remove(file.getName());
        } else {
            this.installCounts.setProperty(file.getName(), Integer.toString(count));
        }
    }

    void uninstall(List<String> artifactIdentifiers) throws Exception {
        File extDirectory = this.getDefaultExtDirectory();
        Log.info("Uninstalling from: " + String.valueOf(extDirectory));
        List<File> artifactFiles = this.dependencyResolver.resolve(artifactIdentifiers);
        for (File artifactFile : artifactFiles) {
            int installCount = this.getInstallCount(artifactFile);
            if (installCount <= 1) {
                new File(extDirectory, artifactFile.getName()).delete();
            }
            this.setInstallCount(artifactFile, installCount - 1);
        }
        this.saveInstallCounts();
    }

    void uninstallAll() throws Exception {
        File extDirectory = this.getDefaultExtDirectory();
        Log.info("Uninstalling from: " + String.valueOf(extDirectory));
        for (String name : this.installCounts.stringPropertyNames()) {
            new File(extDirectory, name).delete();
        }
        this.installCounts.clear();
        this.saveInstallCounts();
    }

    private File getDefaultExtDirectory() {
        String home = SystemPropertyUtils.resolvePlaceholders("${spring.home:${SPRING_HOME:.}}");
        File extDirectory = new File(new File(home, "lib"), "ext");
        if (!extDirectory.isDirectory() && !extDirectory.mkdirs()) {
            throw new IllegalStateException("Failed to create ext directory " + String.valueOf(extDirectory));
        }
        return extDirectory;
    }

    private File getInstalled() {
        return new File(this.getDefaultExtDirectory(), ".installed");
    }
}

