/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.timestamp;

import java.util.Collections;
import java.util.List;
import org.grails.datastore.gorm.timestamp.TimestampProvider;
import org.springframework.beans.factory.annotation.Autowired;

public class AggregateTimestampProvider
implements TimestampProvider {
    private List<TimestampProvider> timestampProviders = Collections.emptyList();

    @Override
    public boolean supportsCreating(Class<?> dateTimeClass) {
        for (TimestampProvider provider : this.timestampProviders) {
            if (!provider.supportsCreating(dateTimeClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T createTimestamp(Class<T> dateTimeClass) {
        if (this.timestampProviders.size() > 1) {
            for (TimestampProvider provider : this.timestampProviders) {
                if (!provider.supportsCreating(dateTimeClass)) continue;
                return this.createTimestamp(provider, dateTimeClass);
            }
        } else {
            return this.createTimestamp(this.timestampProviders.iterator().next(), dateTimeClass);
        }
        throw new IllegalArgumentException("dateTimeClass given as parameter isn't supported by any TimestampProvider. You should call supportsCreating first.");
    }

    protected <T> T createTimestamp(TimestampProvider provider, Class<T> dateTimeClass) {
        return provider.createTimestamp(dateTimeClass);
    }

    public List<TimestampProvider> getTimestampProviders() {
        return this.timestampProviders;
    }

    @Autowired
    public void setTimestampProviders(List<TimestampProvider> timestampProviders) {
        this.timestampProviders = timestampProviders;
    }
}

