/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.build.gradle;

import io.micronaut.core.annotation.NonNull;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.grails.forge.build.gradle.GradleConfiguration;
import org.grails.forge.build.gradle.GradleDependency;
import org.grails.forge.build.gradle.GradleDsl;
import org.grails.forge.build.gradle.GradlePlugin;
import org.grails.forge.build.gradle.GradleRepository;
import org.grails.forge.template.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradleBuild {
    private static final Logger LOG = LoggerFactory.getLogger(GradleBuild.class);
    private final GradleDsl dsl;
    private final List<GradleRepository> repositories;
    private final List<GradleRepository> buildRepositories;
    private final List<GradleDependency> dependencies;
    private final List<GradleDependency> buildscriptDependencies;
    private final List<GradlePlugin> plugins;

    public GradleBuild() {
        this(GradleDsl.GROOVY, Collections.emptyList(), Collections.emptyList());
    }

    public GradleBuild(@NonNull GradleDsl gradleDsl, @NonNull List<GradleDependency> dependencies2, @NonNull List<GradleDependency> buildscriptDependencies) {
        this(gradleDsl, dependencies2, buildscriptDependencies, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public GradleBuild(@NonNull GradleDsl gradleDsl, @NonNull List<GradleDependency> dependencies2, @NonNull List<GradleDependency> buildscriptDependencies, @NonNull List<GradlePlugin> plugins, @NonNull List<GradleRepository> buildRepositories, @NonNull List<GradleRepository> repositories) {
        this.dsl = gradleDsl;
        this.dependencies = dependencies2;
        this.buildscriptDependencies = buildscriptDependencies;
        this.plugins = plugins;
        this.buildRepositories = buildRepositories;
        this.repositories = repositories;
    }

    @NonNull
    public GradleDsl getDsl() {
        return this.dsl;
    }

    @NonNull
    public List<GradleDependency> getDependencies() {
        return this.dependencies;
    }

    @NonNull
    public List<GradleRepository> getBuildRepositories() {
        return this.buildRepositories;
    }

    @NonNull
    public List<GradleRepository> getRepositories() {
        return this.repositories;
    }

    @NonNull
    public List<GradleDependency> getBuildSrcDependencies() {
        return this.buildscriptDependencies.stream().filter(gradleDependency -> !gradleDependency.getConfiguration().equals(GradleConfiguration.CLASSPATH)).collect(Collectors.toList());
    }

    @NonNull
    public List<GradleDependency> getBuildscriptDependencies() {
        return this.buildscriptDependencies.stream().filter(gradleDependency -> gradleDependency.getConfiguration().equals(GradleConfiguration.CLASSPATH)).collect(Collectors.toList());
    }

    @NonNull
    public List<GradleDependency> getAllBuildscriptDependencies() {
        return this.buildscriptDependencies;
    }

    @NonNull
    public List<GradlePlugin> getPlugins() {
        return this.plugins;
    }

    @NonNull
    public List<GradlePlugin> getPluginsWithVersion() {
        return this.plugins.stream().filter(plugin2 -> plugin2.getVersion() != null).collect(Collectors.toList());
    }

    @NonNull
    public List<GradlePlugin> getPluginsWithoutApply() {
        return this.plugins.stream().filter(plugin2 -> !plugin2.useApplyPlugin()).collect(Collectors.toList());
    }

    @NonNull
    public List<GradlePlugin> getPluginsWithApply() {
        return this.plugins.stream().filter(plugin2 -> plugin2.useApplyPlugin()).collect(Collectors.toList());
    }

    @NonNull
    public String renderExtensions() {
        return this.renderWritableExtensions(Stream.concat(this.buildscriptDependencies.stream().map(GradleDependency::getExtension).filter(Objects::nonNull), this.plugins.stream().map(GradlePlugin::getExtension)));
    }

    @NonNull
    public String renderSettingsExtensions() {
        return this.renderWritableExtensions(this.plugins.stream().map(GradlePlugin::getSettingsExtension));
    }

    @NonNull
    private String renderWritableExtensions(Stream<Writable> extensions) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        extensions.filter(Objects::nonNull).forEach(writable -> {
            block2: {
                try {
                    writable.write(outputStream);
                    outputStream.write(System.lineSeparator().getBytes(StandardCharsets.UTF_8));
                }
                catch (IOException e) {
                    if (!LOG.isErrorEnabled()) break block2;
                    LOG.error("IO Exception rendering Gradle Plugin extension");
                }
            }
        });
        return new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
    }

    @NonNull
    public Set<String> getPluginsImports() {
        HashSet<String> imports = new HashSet<String>();
        for (GradlePlugin p : this.plugins) {
            Set<String> pluginImports = p.getBuildImports();
            if (pluginImports == null) continue;
            imports.addAll(pluginImports);
        }
        return imports.stream().map(it -> it + System.lineSeparator()).collect(Collectors.toSet());
    }
}

