/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.cli.command;

import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.core.util.functional.ThrowingSupplier;
import jakarta.inject.Inject;
import java.io.IOException;
import org.grails.forge.application.Project;
import org.grails.forge.cli.CodeGenConfig;
import org.grails.forge.cli.command.CodeGenCommand;
import org.grails.forge.cli.command.templates.taglib;
import org.grails.forge.cli.command.templates.taglibSpec;
import org.grails.forge.io.ConsoleOutput;
import org.grails.forge.io.OutputHandler;
import org.grails.forge.template.RenderResult;
import org.grails.forge.template.RockerTemplate;
import org.grails.forge.template.TemplateRenderer;
import picocli.CommandLine;

@CommandLine.Command(name="create-taglib", description={"Creates a Grails TagLib"})
public class CreateTagLibCommand
extends CodeGenCommand {
    public static final String NAME = "create-taglib";
    @ReflectiveAccess
    @CommandLine.Parameters(paramLabel="TAG-LIB-NAME", description={"The name of the taglib to create"})
    String tagLibName;

    @Inject
    public CreateTagLibCommand(@Parameter CodeGenConfig config) {
        super(config);
    }

    public CreateTagLibCommand(CodeGenConfig config, ThrowingSupplier<OutputHandler, IOException> outputHandlerSupplier, ConsoleOutput consoleOutput) {
        super(config, outputHandlerSupplier, consoleOutput);
    }

    @Override
    public boolean applies() {
        return true;
    }

    @Override
    public Integer call() throws Exception {
        Project project = this.getProject(this.tagLibName);
        TemplateRenderer templateRenderer = this.getTemplateRenderer(project);
        RenderResult controllerRenderResult = templateRenderer.render(new RockerTemplate("grails-app/taglib/{packagePath}/{className}TagLib.groovy", taglib.template(project)), this.overwrite);
        RenderResult controllerSpecRenderResult = templateRenderer.render(new RockerTemplate("src/test/groovy/{packagePath}/{className}TagLibSpec.groovy", taglibSpec.template(project)), this.overwrite);
        if (controllerRenderResult != null && controllerSpecRenderResult != null) {
            this.logRenderResult(controllerRenderResult);
            this.logRenderResult(controllerSpecRenderResult);
        }
        return 0;
    }

    private void logRenderResult(RenderResult result) throws Exception {
        if (result != null) {
            if (result.isSuccess()) {
                this.out("@|blue ||@ Rendered taglib to " + result.getPath());
            } else if (result.isSkipped()) {
                this.warning("Rendering skipped for " + result.getPath() + " because it already exists. Run again with -f to overwrite.");
            } else if (result.getError() != null) {
                throw result.getError();
            }
        }
    }
}

