/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.template;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Objects;
import org.grails.forge.template.Template;

public class URLTemplate
implements Template {
    private final String path;
    private final URL url;
    private final boolean executable;

    public URLTemplate(String path, URL url) {
        this(path, url, false);
    }

    public URLTemplate(String path, URL url, boolean executable) {
        this.path = path;
        this.url = Objects.requireNonNull(url, "Resource not found for url: " + String.valueOf(url));
        this.executable = executable;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        try (InputStream inputStream = this.url.openStream();){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, len);
            }
        }
    }

    @Override
    public boolean isExecutable() {
        return this.executable;
    }

    @Override
    public String getPath() {
        return this.path;
    }
}

