/*
 * Decompiled with CFR 0.152.
 */
package org.grails.gsp.compiler;

import grails.util.GrailsStringUtils;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import org.grails.gsp.compiler.GroovyPageParser;

public class GSPWriter
extends PrintWriter {
    private int lineNumber = 1;
    private int[] lineNumbers = new int[1000];
    private GroovyPageParser parse;

    public GSPWriter(Writer out, GroovyPageParser parse) {
        super(out);
        this.parse = parse;
    }

    @Override
    public void write(char[] buf, int off, int len) {
        super.write(buf, off, len);
    }

    public void printlnToResponse(String s) {
        this.printlnToResponse("out", s);
    }

    public void printlnToResponse(String outVarName, String s) {
        if (GrailsStringUtils.isEmpty(s)) {
            return;
        }
        this.parse.flushTagBuffering();
        super.print(outVarName);
        super.print(".print(");
        super.print(s);
        super.print(")");
        this.println();
    }

    public void printlnToBuffer(String s, int index2) {
        if (s == null) {
            s = "''";
        }
        super.print("buf" + index2 + " << ");
        super.print(s);
        this.println();
    }

    @Override
    public void println() {
        this.addLineNumber();
        super.println();
    }

    private void addLineNumber() {
        if (this.lineNumber >= this.lineNumbers.length) {
            this.lineNumbers = (int[])this.resizeArray(this.lineNumbers, this.lineNumbers.length * 2);
        } else {
            this.lineNumbers[this.lineNumber - 1] = this.parse.getCurrentOutputLineNumber();
            ++this.lineNumber;
        }
    }

    private Object resizeArray(Object oldArray, int newSize) {
        int oldSize = Array.getLength(oldArray);
        Class<?> elementType = oldArray.getClass().getComponentType();
        Object newArray = Array.newInstance(elementType, newSize);
        int preserveLength = Math.min(oldSize, newSize);
        if (preserveLength > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, preserveLength);
        }
        return newArray;
    }

    public int getCurrentLineNumber() {
        return this.lineNumber;
    }

    public int[] getLineNumbers() {
        return this.lineNumbers;
    }
}

