/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.core.annotation.AliasFor;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class AnnotationBeanNameGenerator
implements BeanNameGenerator {
    public static final AnnotationBeanNameGenerator INSTANCE = new AnnotationBeanNameGenerator();
    private static final String COMPONENT_ANNOTATION_CLASSNAME = "org.springframework.stereotype.Component";
    private static final MergedAnnotation.Adapt[] ADAPTATIONS = MergedAnnotation.Adapt.values(false, true);
    private static final Log logger = LogFactory.getLog(AnnotationBeanNameGenerator.class);
    private static final Set<String> conventionBasedStereotypeCheckCache = ConcurrentHashMap.newKeySet();
    private final Map<String, Set<String>> metaAnnotationTypesCache = new ConcurrentHashMap<String, Set<String>>();

    @Override
    public String generateBeanName(BeanDefinition definition, BeanDefinitionRegistry registry) {
        AnnotatedBeanDefinition annotatedBeanDefinition;
        String beanName;
        if (definition instanceof AnnotatedBeanDefinition && StringUtils.hasText(beanName = this.determineBeanNameFromAnnotation(annotatedBeanDefinition = (AnnotatedBeanDefinition)definition))) {
            return beanName;
        }
        return this.buildDefaultBeanName(definition, registry);
    }

    @Nullable
    protected String determineBeanNameFromAnnotation(AnnotatedBeanDefinition annotatedDef) {
        AnnotationMetadata metadata = annotatedDef.getMetadata();
        String beanName = this.getExplicitBeanName(metadata);
        if (beanName != null) {
            return beanName;
        }
        List<MergedAnnotation> mergedAnnotations = metadata.getAnnotations().stream().filter(MergedAnnotation::isDirectlyPresent).toList();
        HashSet<AnnotationAttributes> visited = new HashSet<AnnotationAttributes>();
        for (MergedAnnotation mergedAnnotation : mergedAnnotations) {
            String currentName;
            Object value;
            Set metaAnnotationTypes;
            String annotationType;
            AnnotationAttributes attributes = mergedAnnotation.asAnnotationAttributes(ADAPTATIONS);
            if (!visited.add(attributes) || !this.isStereotypeWithNameValue(annotationType = mergedAnnotation.getType().getName(), metaAnnotationTypes = this.metaAnnotationTypesCache.computeIfAbsent(annotationType, key -> this.getMetaAnnotationTypes(mergedAnnotation)), attributes) || !((value = attributes.get("value")) instanceof String) || (currentName = (String)value).isBlank()) continue;
            if (conventionBasedStereotypeCheckCache.add(annotationType) && metaAnnotationTypes.contains(COMPONENT_ANNOTATION_CLASSNAME) && logger.isWarnEnabled()) {
                if (AnnotationBeanNameGenerator.hasExplicitlyAliasedValueAttribute(mergedAnnotation.getType())) {
                    logger.warn("Although the 'value' attribute in @%s declares @AliasFor for an attribute other than @Component's 'value' attribute, the value is still used as the @Component name based on convention. As of Spring Framework 7.0, such a 'value' attribute will no longer be used as the @Component name.".formatted(annotationType));
                } else {
                    logger.warn("Support for convention-based @Component names is deprecated and will be removed in a future version of the framework. Please annotate the 'value' attribute in @%s with @AliasFor(annotation=Component.class) to declare an explicit alias for @Component's 'value' attribute.".formatted(annotationType));
                }
            }
            if (beanName != null && !currentName.equals(beanName)) {
                throw new IllegalStateException("Stereotype annotations suggest inconsistent component names: '" + beanName + "' versus '" + currentName + "'");
            }
            beanName = currentName;
        }
        return beanName;
    }

    private Set<String> getMetaAnnotationTypes(MergedAnnotation<Annotation> mergedAnnotation) {
        Set result = MergedAnnotations.from(mergedAnnotation.getType()).stream().map(metaAnnotation -> metaAnnotation.getType().getName()).collect(Collectors.toCollection(LinkedHashSet::new));
        return result.isEmpty() ? Collections.emptySet() : result;
    }

    @Nullable
    private String getExplicitBeanName(AnnotationMetadata metadata) {
        List<String> names = metadata.getAnnotations().stream(COMPONENT_ANNOTATION_CLASSNAME).map(annotation -> annotation.getString("value")).filter(StringUtils::hasText).map(String::trim).distinct().toList();
        if (names.size() == 1) {
            return names.get(0);
        }
        if (names.size() > 1) {
            throw new IllegalStateException("Stereotype annotations suggest inconsistent component names: " + String.valueOf(names));
        }
        return null;
    }

    protected boolean isStereotypeWithNameValue(String annotationType, Set<String> metaAnnotationTypes, Map<String, Object> attributes) {
        boolean isStereotype = metaAnnotationTypes.contains(COMPONENT_ANNOTATION_CLASSNAME) || annotationType.equals("jakarta.annotation.ManagedBean") || annotationType.equals("javax.annotation.ManagedBean") || annotationType.equals("jakarta.inject.Named") || annotationType.equals("javax.inject.Named");
        return isStereotype && attributes.containsKey("value");
    }

    protected String buildDefaultBeanName(BeanDefinition definition, BeanDefinitionRegistry registry) {
        return this.buildDefaultBeanName(definition);
    }

    protected String buildDefaultBeanName(BeanDefinition definition) {
        String beanClassName = definition.getBeanClassName();
        Assert.state(beanClassName != null, "No bean class name set");
        String shortClassName = ClassUtils.getShortName(beanClassName);
        return StringUtils.uncapitalizeAsProperty(shortClassName);
    }

    private static boolean hasExplicitlyAliasedValueAttribute(Class<? extends Annotation> annotationType) {
        Method valueAttribute = ReflectionUtils.findMethod(annotationType, "value");
        return valueAttribute != null && valueAttribute.isAnnotationPresent(AliasFor.class);
    }
}

