/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package grails.gorm.tests

import com.mongodb.client.FindIterable
import org.apache.grails.data.mongo.core.GrailsDataMongoTckManager
import org.apache.grails.data.testing.tck.base.GrailsDataTckSpec
import org.bson.Document
import org.grails.datastore.gorm.mongo.Product
//tag::nativeImport[]

import static com.mongodb.client.model.Filters.eq

//end::nativeImport[]
/**
 * Created by graemerocher on 24/10/16.
 */
class FindNativeSpec extends GrailsDataTckSpec<GrailsDataMongoTckManager> {

    void setupSpec() {
        manager.domainClasses.addAll([Product])
    }

    void "test native find method"() {
        setup:
        Product.DB.drop()
        new Product(title: "cake").save()
        new Product(title: "coffee").save(flush: true)

        when: "the native find method is used"
        //tag::nativeFind[]
        FindIterable findIterable = Product.find(eq("title", "coffee"))
        findIterable.limit(10)
                .each { Product product ->
                    println "Product title $product.title"
                }
        //end::nativeFind[]

        //tag::collectionFind[]
        Document doc = Product.collection
                .find(eq("title", "coffee"))
                .first()

        //end::collectionFind[]

        then: "The results are correct"
        findIterable.size() == 1
        doc != null

        when: "findAndDeleteOne is used"
        Product p = Product.findOneAndDelete(eq("title", "coffee"))

        then: "The right one was deleted"
        Product.count == 1
        Product.findByTitle("cake")
        p.title == 'coffee'
    }
}
