/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.core.DiscoveryIssueException;

class DiscoveryIssueNotifier {
    static final DiscoveryIssueNotifier NO_ISSUES = new DiscoveryIssueNotifier(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    private static final Logger logger = LoggerFactory.getLogger(DiscoveryIssueNotifier.class);
    private final List<DiscoveryIssue> allIssues;
    private final List<DiscoveryIssue> criticalIssues;
    private final List<DiscoveryIssue> nonCriticalIssues;

    static DiscoveryIssueNotifier from(DiscoveryIssue.Severity criticalSeverity, List<DiscoveryIssue> issues) {
        Map<Boolean, List<DiscoveryIssue>> issuesByCriticality = issues.stream().sorted(Comparator.comparing(DiscoveryIssue::severity).reversed()).collect(Collectors.partitioningBy(issue -> issue.severity().compareTo((Enum)criticalSeverity) >= 0));
        List<DiscoveryIssue> criticalIssues = issuesByCriticality.get(true);
        List<DiscoveryIssue> nonCriticalIssues = issuesByCriticality.get(false);
        return new DiscoveryIssueNotifier(new ArrayList<DiscoveryIssue>(issues), criticalIssues, nonCriticalIssues);
    }

    private DiscoveryIssueNotifier(List<DiscoveryIssue> allIssues, List<DiscoveryIssue> criticalIssues, List<DiscoveryIssue> nonCriticalIssues) {
        this.allIssues = allIssues;
        this.criticalIssues = criticalIssues;
        this.nonCriticalIssues = nonCriticalIssues;
    }

    List<DiscoveryIssue> getAllIssues() {
        return this.allIssues;
    }

    boolean hasCriticalIssues() {
        return !this.criticalIssues.isEmpty();
    }

    void logCriticalIssues(TestEngine testEngine) {
        this.logIssues(testEngine, this.criticalIssues, "critical");
    }

    void logNonCriticalIssues(TestEngine testEngine) {
        this.logIssues(testEngine, this.nonCriticalIssues, "non-critical");
    }

    DiscoveryIssueException createExceptionForCriticalIssues(TestEngine testEngine) {
        if (this.criticalIssues.isEmpty()) {
            return null;
        }
        String message = DiscoveryIssueNotifier.formatMessage(testEngine, this.criticalIssues, "critical");
        return new DiscoveryIssueException(message);
    }

    private void logIssues(TestEngine testEngine, List<DiscoveryIssue> issues, String adjective) {
        if (!issues.isEmpty()) {
            DiscoveryIssue.Severity maxSeverity = issues.get(0).severity();
            DiscoveryIssueNotifier.logger(maxSeverity).accept(() -> DiscoveryIssueNotifier.formatMessage(testEngine, issues, adjective));
        }
    }

    private static Consumer<Supplier<String>> logger(DiscoveryIssue.Severity severity) {
        switch (severity) {
            case INFO: {
                return arg_0 -> ((Logger)logger).info(arg_0);
            }
            case WARNING: {
                return arg_0 -> ((Logger)logger).warn(arg_0);
            }
            case ERROR: {
                return arg_0 -> ((Logger)logger).error(arg_0);
            }
        }
        throw new IllegalArgumentException("Unknown severity: " + severity);
    }

    private static String formatMessage(TestEngine testEngine, List<DiscoveryIssue> issues, String adjective) {
        Preconditions.notNull((Object)testEngine, (String)"testEngine must not be null");
        Preconditions.notNull(issues, (String)"issues must not be null");
        Preconditions.notEmpty(issues, (String)"issues must not be empty");
        String engineId = testEngine.getId();
        StringBuilder message = new StringBuilder();
        message.append("TestEngine with ID '").append(engineId).append("' encountered ");
        if (issues.size() == 1) {
            message.append("a ").append(adjective).append(" issue");
        } else {
            message.append(issues.size()).append(' ').append(adjective).append(" issues");
        }
        message.append(" during test discovery:");
        for (int i = 0; i < issues.size(); ++i) {
            DiscoveryIssue issue = issues.get(i);
            message.append("\n\n(").append(i + 1).append(") [").append(issue.severity()).append("] ").append(issue.message());
            issue.source().ifPresent(source -> {
                message.append("\n    Source: ").append(source);
                if (source instanceof MethodSource) {
                    MethodSource methodSource = (MethodSource)source;
                    DiscoveryIssueNotifier.appendIdeCompatibleLink(message, methodSource.getClassName(), methodSource.getMethodName());
                } else if (source instanceof ClassSource) {
                    ClassSource classSource = (ClassSource)source;
                    DiscoveryIssueNotifier.appendIdeCompatibleLink(message, classSource.getClassName(), "<no-method>");
                }
            });
            issue.cause().ifPresent(t -> message.append("\n    Cause: ").append(ExceptionUtils.readStackTrace((Throwable)t)));
        }
        return message.toString();
    }

    private static void appendIdeCompatibleLink(StringBuilder message, String className, String methodName) {
        message.append("\n            at ").append(className).append(".").append(methodName).append("(SourceFile:0)");
    }
}

