/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine;

import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.ToStringBuilder;

@API(status=API.Status.STABLE, since="1.10")
public class SelectorResolutionResult {
    private static final SelectorResolutionResult RESOLVED_RESULT = new SelectorResolutionResult(Status.RESOLVED, null);
    private static final SelectorResolutionResult UNRESOLVED_RESULT = new SelectorResolutionResult(Status.UNRESOLVED, null);
    private final Status status;
    private final Throwable throwable;

    public static SelectorResolutionResult resolved() {
        return RESOLVED_RESULT;
    }

    public static SelectorResolutionResult unresolved() {
        return UNRESOLVED_RESULT;
    }

    public static SelectorResolutionResult failed(Throwable throwable) {
        return new SelectorResolutionResult(Status.FAILED, throwable);
    }

    private SelectorResolutionResult(Status status, Throwable throwable) {
        this.status = status;
        this.throwable = throwable;
    }

    public Status getStatus() {
        return this.status;
    }

    public Optional<Throwable> getThrowable() {
        return Optional.ofNullable(this.throwable);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("status", (Object)this.status).append("throwable", (Object)this.throwable).toString();
    }

    public static enum Status {
        RESOLVED,
        UNRESOLVED,
        FAILED;

    }
}

