/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.framework;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.testing.framework.TestingFramework;
import org.apache.hc.core5.testing.framework.TestingFrameworkException;

public class FrameworkTest {
    private Map<String, Object> request = new HashMap<String, Object>();
    private Map<String, Object> response = new HashMap<String, Object>();

    public FrameworkTest() {
        this(null);
    }

    public FrameworkTest(Map<String, Object> test) {
        if (test != null) {
            if (test.containsKey("request")) {
                this.request = (Map)test.get("request");
            }
            if (test.containsKey("response")) {
                this.response = (Map)test.get("response");
            }
        }
    }

    public Map<String, Object> initRequest() throws TestingFrameworkException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("path", "a/path");
        ret.put("body", "{\"location\":\"home\"}");
        ret.put("contentType", "application/json");
        ret.put("query", new HashMap<String, String>(TestingFramework.DEFAULT_REQUEST_QUERY));
        ret.put("headers", new HashMap<String, String>(TestingFramework.DEFAULT_REQUEST_HEADERS));
        ret.put("protocolVersion", TestingFramework.DEFAULT_REQUEST_PROTOCOL_VERSION);
        if (!this.request.containsKey("method")) {
            this.request.put("method", "GET");
        }
        ret.putAll(this.request);
        this.moveAnyParametersInPathToQuery(ret);
        return ret;
    }

    private void moveAnyParametersInPathToQuery(Map<String, Object> request) throws TestingFrameworkException {
        try {
            String path = (String)request.get("path");
            if (path != null) {
                URI uri = path.startsWith("/") ? new URI("http://localhost:8080" + path) : new URI("http://localhost:8080/");
                URIBuilder uriBuilder = new URIBuilder(uri, StandardCharsets.UTF_8);
                List params = uriBuilder.getQueryParams();
                Map queryMap = (Map)request.get("query");
                for (NameValuePair param : params) {
                    queryMap.put(param.getName(), param.getValue());
                }
                if (!params.isEmpty()) {
                    request.put("path", uri.getPath());
                }
            }
        }
        catch (URISyntaxException e) {
            throw new TestingFrameworkException(e);
        }
    }

    public Map<String, Object> initResponseExpectations() {
        if (!this.response.containsKey("status")) {
            this.response.put("status", 200);
        }
        HashMap<String, Object> responseExpectations = new HashMap<String, Object>();
        responseExpectations.put("body", "{\"location\":\"work\"}");
        responseExpectations.put("contentType", "application/json");
        responseExpectations.put("headers", new HashMap<String, String>(TestingFramework.DEFAULT_RESPONSE_HEADERS));
        responseExpectations.putAll(this.response);
        return responseExpectations;
    }

    public String toString() {
        return "request: " + this.request + "\nresponse: " + this.response;
    }
}

