/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl;

import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestDefaultConnectionReuseStrategy {
    private HttpCoreContext context;
    private ConnectionReuseStrategy reuseStrategy;

    TestDefaultConnectionReuseStrategy() {
    }

    @BeforeEach
    void setUp() {
        this.reuseStrategy = DefaultConnectionReuseStrategy.INSTANCE;
        this.context = HttpCoreContext.create();
    }

    @Test
    void testInvalidResponseArg() {
        Assertions.assertThrows(NullPointerException.class, () -> this.reuseStrategy.keepAlive(null, null, (HttpContext)this.context));
    }

    @Test
    void testNoContentLengthResponseHttp1_0() {
        this.context.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        Assertions.assertFalse((boolean)this.reuseStrategy.keepAlive(null, (HttpResponse)response, (HttpContext)this.context));
    }

    @Test
    void testNoContentLengthResponseHttp1_1() {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        Assertions.assertFalse((boolean)this.reuseStrategy.keepAlive(null, (HttpResponse)response, (HttpContext)this.context));
    }

    @Test
    void testChunkedContent() {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        response.addHeader("Transfer-Encoding", (Object)"chunked");
        Assertions.assertTrue((boolean)this.reuseStrategy.keepAlive(null, (HttpResponse)response, (HttpContext)this.context));
    }

    @Test
    void testIgnoreInvalidKeepAlive() {
        this.context.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        response.addHeader("Connection", (Object)"keep-alive");
        Assertions.assertFalse((boolean)this.reuseStrategy.keepAlive(null, (HttpResponse)response, (HttpContext)this.context));
    }

    @Test
    void testExplicitClose() {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        response.addHeader("Transfer-Encoding", (Object)"chunked");
        response.addHeader("Connection", (Object)"close");
        Assertions.assertFalse((boolean)this.reuseStrategy.keepAlive(null, (HttpResponse)response, (HttpContext)this.context));
    }

    @Test
    void testExplicitKeepAlive() {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        response.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        response.addHeader("Content-Length", (Object)"10");
        response.addHeader("Connection", (Object)"keep-alive");
        Assertions.assertTrue((boolean)this.reuseStrategy.keepAlive(null, (HttpResponse)response, (HttpContext)this.context));
    }

    @Test
    void testHTTP10Default() {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        response.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        response.addHeader("Content-Length", (Object)"10");
        Assertions.assertFalse((boolean)this.reuseStrategy.keepAlive(null, (HttpResponse)response, (HttpContext)this.context));
    }

    @Test
    void testHTTP11Default() {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        response.addHeader("Content-Length", (Object)"10");
        Assertions.assertTrue((boolean)this.reuseStrategy.keepAlive(null, (HttpResponse)response, (HttpContext)this.context));
    }

    @Test
    void testBrokenConnectionDirective1() {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        response.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        response.addHeader("Content-Length", (Object)"10");
        response.addHeader("Connection", (Object)"keep--alive");
        Assertions.assertFalse((boolean)this.reuseStrategy.keepAlive(null, (HttpResponse)response, (HttpContext)this.context));
    }

    @Test
    void testBrokenConnectionDirective2() {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        response.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        response.addHeader("Content-Length", (Object)"10");
        response.addHeader("Connection", null);
        Assertions.assertFalse((boolean)this.reuseStrategy.keepAlive(null, (HttpResponse)response, (HttpContext)this.context));
    }

    @Test
    void testConnectionTokens1() {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        response.addHeader("Transfer-Encoding", (Object)"chunked");
        response.addHeader("Connection", (Object)"yadda, cLOSe, dumdy");
        Assertions.assertFalse((boolean)this.reuseStrategy.keepAlive(null, (HttpResponse)response, (HttpContext)this.context));
    }

    @Test
    void testConnectionTokens2() {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        response.addHeader("Transfer-Encoding", (Object)"chunked");
        response.addHeader("Connection", (Object)"yadda, kEEP-alive, dumdy");
        Assertions.assertTrue((boolean)this.reuseStrategy.keepAlive(null, (HttpResponse)response, (HttpContext)this.context));
    }

    @Test
    void testConnectionTokens3() {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        response.addHeader("Transfer-Encoding", (Object)"chunked");
        response.addHeader("Connection", (Object)"yadda, keep-alive, close, dumdy");
        Assertions.assertFalse((boolean)this.reuseStrategy.keepAlive(null, (HttpResponse)response, (HttpContext)this.context));
    }

    @Test
    void testConnectionTokens4() {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        response.addHeader("Transfer-Encoding", (Object)"chunked");
        response.addHeader("Connection", (Object)"yadda, close, dumdy");
        response.addHeader("Proxy-Connection", (Object)"keep-alive");
        Assertions.assertFalse((boolean)this.reuseStrategy.keepAlive(null, (HttpResponse)response, (HttpContext)this.context));
    }

    @Test
    void testConnectionTokens5() {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        response.addHeader("Transfer-Encoding", (Object)"chunked");
        response.addHeader("Connection", (Object)"yadda, dumdy");
        response.addHeader("Proxy-Connection", (Object)"close");
        Assertions.assertTrue((boolean)this.reuseStrategy.keepAlive(null, (HttpResponse)response, (HttpContext)this.context));
    }

    @Test
    void testConnectionTokens6() {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        response.addHeader("Transfer-Encoding", (Object)"chunked");
        response.addHeader("Connection", (Object)"");
        response.addHeader("Proxy-Connection", (Object)"close");
        Assertions.assertTrue((boolean)this.reuseStrategy.keepAlive(null, (HttpResponse)response, (HttpContext)this.context));
    }

    @Test
    void testMultipleContentLength() {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        response.addHeader("Content-Length", (Object)"10");
        response.addHeader("Content-Length", (Object)"11");
        Assertions.assertFalse((boolean)this.reuseStrategy.keepAlive(null, (HttpResponse)response, (HttpContext)this.context));
    }

    @Test
    void testNoContentResponse() {
        BasicHttpResponse response = new BasicHttpResponse(204, "No Content");
        Assertions.assertTrue((boolean)this.reuseStrategy.keepAlive(null, (HttpResponse)response, (HttpContext)this.context));
    }

    @Test
    void testNoContentResponseHttp10() {
        BasicHttpResponse response = new BasicHttpResponse(204, "No Content");
        response.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        Assertions.assertFalse((boolean)this.reuseStrategy.keepAlive(null, (HttpResponse)response, (HttpContext)this.context));
    }

    @Test
    void testRequestExplicitClose() {
        BasicHttpRequest request = new BasicHttpRequest(Method.GET, "/");
        request.addHeader("Connection", (Object)"close");
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        response.addHeader("Transfer-Encoding", (Object)"chunked");
        response.addHeader("Connection", (Object)"keep-alive");
        Assertions.assertFalse((boolean)this.reuseStrategy.keepAlive((HttpRequest)request, (HttpResponse)response, (HttpContext)this.context));
    }

    @Test
    void testRequestNoExplicitClose() {
        BasicHttpRequest request = new BasicHttpRequest(Method.GET, "/");
        request.addHeader("Connection", (Object)"blah, blah, blah");
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        response.addHeader("Transfer-Encoding", (Object)"chunked");
        response.addHeader("Connection", (Object)"keep-alive");
        Assertions.assertTrue((boolean)this.reuseStrategy.keepAlive((HttpRequest)request, (HttpResponse)response, (HttpContext)this.context));
    }

    @Test
    void testRequestExplicitCloseMultipleTokens() {
        BasicHttpRequest request = new BasicHttpRequest(Method.GET, "/");
        request.addHeader("Connection", (Object)"blah, blah, blah");
        request.addHeader("Connection", (Object)"keep-alive");
        request.addHeader("Connection", (Object)"close");
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        response.addHeader("Transfer-Encoding", (Object)"chunked");
        response.addHeader("Connection", (Object)"keep-alive");
        Assertions.assertFalse((boolean)this.reuseStrategy.keepAlive((HttpRequest)request, (HttpResponse)response, (HttpContext)this.context));
    }

    @Test
    void testRequestClose() {
        BasicHttpRequest request = new BasicHttpRequest(Method.GET, "/");
        request.addHeader("Connection", (Object)"close");
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        response.addHeader("Content-Length", (Object)"10");
        response.addHeader("Connection", (Object)"keep-alive");
        Assertions.assertFalse((boolean)this.reuseStrategy.keepAlive((HttpRequest)request, (HttpResponse)response, (HttpContext)this.context));
    }

    @Test
    void testHeadRequestWithout() {
        BasicHttpRequest request = new BasicHttpRequest(Method.HEAD, "/");
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        Assertions.assertTrue((boolean)this.reuseStrategy.keepAlive((HttpRequest)request, (HttpResponse)response, (HttpContext)this.context));
    }

    @Test
    void testHttp204ContentLengthGreaterThanZero() {
        BasicHttpResponse response = new BasicHttpResponse(204, "OK");
        response.addHeader("Content-Length", (Object)"10");
        response.addHeader("Connection", (Object)"keep-alive");
        Assertions.assertFalse((boolean)this.reuseStrategy.keepAlive(null, (HttpResponse)response, (HttpContext)this.context));
    }

    @Test
    void testHttp204ContentLengthEqualToZero() {
        BasicHttpResponse response = new BasicHttpResponse(204, "OK");
        response.addHeader("Content-Length", (Object)"0");
        response.addHeader("Connection", (Object)"keep-alive");
        Assertions.assertTrue((boolean)this.reuseStrategy.keepAlive(null, (HttpResponse)response, (HttpContext)this.context));
    }

    @Test
    void testHttp204ChunkedContent() {
        BasicHttpResponse response = new BasicHttpResponse(204, "OK");
        response.addHeader("Transfer-Encoding", (Object)"chunked");
        response.addHeader("Connection", (Object)"keep-alive");
        Assertions.assertFalse((boolean)this.reuseStrategy.keepAlive(null, (HttpResponse)response, (HttpContext)this.context));
    }

    @Test
    void testResponseHTTP10TransferEncodingPresent() {
        BasicHttpResponse response = new BasicHttpResponse(200, "OK");
        response.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        response.addHeader("Transfer-Encoding", (Object)"chunked");
        response.addHeader("Connection", (Object)"keep-alive");
        Assertions.assertFalse((boolean)this.reuseStrategy.keepAlive(null, (HttpResponse)response, (HttpContext)this.context));
    }
}

