/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.filter;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.filter.DefaultFilterEntry;
import io.micronaut.http.filter.FilterPatternStyle;
import io.micronaut.http.filter.HttpFilter;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public interface HttpFilterResolver<F extends HttpFilter, T extends AnnotationMetadataProvider> {
    public List<FilterEntry<F>> resolveFilterEntries(T var1);

    public List<F> resolveFilters(HttpRequest<?> var1, List<FilterEntry<F>> var2);

    public static interface FilterEntry<F>
    extends AnnotationMetadataProvider {
        @NonNull
        public F getFilter();

        @NonNull
        public Set<HttpMethod> getFilterMethods();

        @NonNull
        public String[] getPatterns();

        default public FilterPatternStyle getPatternStyle() {
            return FilterPatternStyle.defaultStyle();
        }

        default public boolean hasMethods() {
            return CollectionUtils.isNotEmpty(this.getFilterMethods());
        }

        default public boolean hasPatterns() {
            return ArrayUtils.isNotEmpty((Object[])this.getPatterns());
        }

        public static <FT extends HttpFilter> FilterEntry<FT> of(@NonNull FT filter, @Nullable AnnotationMetadata annotationMetadata, @Nullable Set<HttpMethod> methods, String ... patterns) {
            return new DefaultFilterEntry<FT>(Objects.requireNonNull(filter, "Filter cannot be null"), annotationMetadata != null ? annotationMetadata : AnnotationMetadata.EMPTY_METADATA, methods, null, patterns);
        }

        public static <FT extends HttpFilter> FilterEntry<FT> of(@NonNull FT filter, @Nullable AnnotationMetadata annotationMetadata, @Nullable Set<HttpMethod> methods, @NonNull FilterPatternStyle patternStyle, String ... patterns) {
            return new DefaultFilterEntry<FT>(Objects.requireNonNull(filter, "Filter cannot be null"), annotationMetadata != null ? annotationMetadata : AnnotationMetadata.EMPTY_METADATA, methods, patternStyle, patterns);
        }
    }
}

